/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import org.apache.unomi.graphql.scalars.DateFunction;
import org.apache.unomi.graphql.scalars.DateTimeFunction;

public class PropertyValueTypeHelper {
    public static String getPropertyValueParameter(String typeName, String fieldName, DataFetchingEnvironment environment) {
        GraphQLObjectType objectType = environment.getGraphQLSchema().getObjectType(typeName);
        GraphQLOutputType fieldType = objectType.getFieldDefinition(fieldName).getType();
        return PropertyValueTypeHelper.getPropertyValueParameter((GraphQLType)fieldType);
    }

    public static String getPropertyValueParameterForInputType(String typeName, String fieldName, DataFetchingEnvironment environment) {
        GraphQLInputObjectType objectType = (GraphQLInputObjectType)environment.getGraphQLSchema().getType(typeName);
        GraphQLInputType fieldType = objectType.getFieldDefinition(fieldName).getType();
        return PropertyValueTypeHelper.getPropertyValueParameter((GraphQLType)fieldType);
    }

    public static String getPropertyValueParameter(GraphQLType fieldType) {
        if (!(fieldType instanceof GraphQLScalarType)) {
            return "propertyValue";
        }
        GraphQLScalarType scalarType = (GraphQLScalarType)fieldType;
        if (Scalars.GraphQLFloat.getName().equals(scalarType.getName()) || Scalars.GraphQLInt.getName().equals(scalarType.getName()) || Scalars.GraphQLLong.getName().equals(scalarType.getName()) || Scalars.GraphQLFloat.getName().equals(scalarType.getName()) || Scalars.GraphQLBigDecimal.getName().equals(scalarType.getName()) || Scalars.GraphQLBigInteger.getName().equals(scalarType.getName())) {
            return "propertyValueInteger";
        }
        if (DateTimeFunction.DATE_TIME_SCALAR.getName().equals(scalarType.getName()) || DateFunction.DATE_SCALAR.getName().equals(scalarType.getName())) {
            return "propertyValueDate";
        }
        return "propertyValue";
    }
}

