/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema.json;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.unomi.graphql.schema.json.JSONType;
import org.apache.unomi.graphql.schema.json.JSONTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONObjectType
extends JSONType {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONTypeFactory.class);
    Map<String, List<JSONType>> properties = new HashMap<String, List<JSONType>>();
    JSONType additionalProperties;
    Map<String, List<JSONType>> patternProperties = new HashMap<String, List<JSONType>>();
    JSONType propertyNames;
    int maxProperties;

    public JSONObjectType(Map<String, Object> schemaTree, JSONTypeFactory jsonTypeFactory) {
        super(schemaTree, jsonTypeFactory);
        this.setType("object");
        Map propertiesTree = (Map)schemaTree.get("properties");
        if (propertiesTree != null) {
            propertiesTree.entrySet().forEach(entry -> {
                if (entry.getValue() instanceof Map) {
                    this.properties.put((String)entry.getKey(), jsonTypeFactory.getTypes((Map)entry.getValue()));
                } else {
                    LOGGER.error("Expected map type for property {}, instead found {}", entry.getKey(), entry.getValue().getClass());
                }
            });
        }
    }

    public Map<String, List<JSONType>> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, List<JSONType>> properties) {
        this.properties = properties;
    }
}

