/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema.json;

import java.util.List;
import java.util.Map;
import org.apache.unomi.api.PluginType;
import org.apache.unomi.graphql.schema.json.JSONType;
import org.apache.unomi.graphql.schema.json.JSONTypeFactory;

public class JSONSchema
extends JSONType
implements PluginType {
    private transient long pluginId;
    private String schemaId;
    private String target;
    private List<JSONType> rootTypes;
    private String vendor;
    private String name;
    private String version;

    public JSONSchema(Map<String, Object> schemaTree, JSONTypeFactory jsonTypeFactory) {
        super(schemaTree, jsonTypeFactory);
        this.schemaId = (String)schemaTree.get("$id");
        if (schemaTree.containsKey("self")) {
            Map self = (Map)schemaTree.get("self");
            this.name = (String)self.get("name");
            this.vendor = (String)self.get("vendor");
            this.version = (String)self.get("version");
            this.target = (String)self.get("target");
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(long pluginId) {
        this.pluginId = pluginId;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public List<JSONType> getRootTypes() {
        if (this.rootTypes == null) {
            this.buildRootTypes();
        }
        return this.rootTypes;
    }

    private void buildRootTypes() {
        this.rootTypes = this.jsonTypeFactory.getTypes(this.schemaTree);
    }
}

