/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.unomi.graphql.schema.json.JSONTypeFactory;

public class JSONType {
    String type;
    String name;
    List<String> required;
    String ref;
    List<JSONType> anyOf;
    List<JSONType> oneOf;
    Map<String, Object> customKeywords;
    protected Map<String, Object> schemaTree;
    protected JSONTypeFactory jsonTypeFactory;

    public JSONType(Map<String, Object> schemaTree, JSONTypeFactory jsonTypeFactory) {
        this.schemaTree = schemaTree;
        this.jsonTypeFactory = jsonTypeFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, Object> getSchemaTree() {
        return this.schemaTree;
    }

    public JSONTypeFactory getJsonTypeFactory() {
        return this.jsonTypeFactory;
    }

    public String getRef() {
        this.ref = (String)this.schemaTree.get("$ref");
        return this.ref;
    }

    public List<JSONType> getAllOf() {
        List allOfTree = (List)this.schemaTree.get("allOf");
        ArrayList<JSONType> allOfTypes = new ArrayList<JSONType>();
        if (allOfTree != null) {
            for (Map allOfEntry : allOfTree) {
                List<JSONType> entryTypes = this.jsonTypeFactory.getTypes(allOfEntry);
                allOfTypes.addAll(entryTypes);
            }
        }
        return allOfTypes;
    }

    public List<JSONType> getAnyOf() {
        return this.anyOf;
    }

    public List<JSONType> getOneOf() {
        return this.oneOf;
    }

    public Map<String, Object> getCustomKeywords() {
        return this.customKeywords;
    }

    public boolean merge(JSONType anotherType) {
        return anotherType.getType().equals(this.getType());
    }
}

