/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema.json;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.unomi.graphql.schema.GraphQLSchemaProvider;
import org.apache.unomi.graphql.schema.json.JSONArrayType;
import org.apache.unomi.graphql.schema.json.JSONBooleanType;
import org.apache.unomi.graphql.schema.json.JSONEnumType;
import org.apache.unomi.graphql.schema.json.JSONIntegerType;
import org.apache.unomi.graphql.schema.json.JSONNullType;
import org.apache.unomi.graphql.schema.json.JSONNumberType;
import org.apache.unomi.graphql.schema.json.JSONObjectType;
import org.apache.unomi.graphql.schema.json.JSONStringType;
import org.apache.unomi.graphql.schema.json.JSONType;
import org.apache.unomi.schema.api.JsonSchemaWrapper;
import org.apache.unomi.schema.api.SchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONTypeFactory.class);
    Map<String, Class<? extends JSONType>> jsonTypes = new HashMap<String, Class<? extends JSONType>>();
    SchemaService schemaService;

    public JSONTypeFactory(SchemaService schemaService) {
        this.schemaService = schemaService;
        this.jsonTypes.put("object", JSONObjectType.class);
        this.jsonTypes.put("string", JSONStringType.class);
        this.jsonTypes.put("array", JSONArrayType.class);
        this.jsonTypes.put("number", JSONNumberType.class);
        this.jsonTypes.put("integer", JSONIntegerType.class);
        this.jsonTypes.put("boolean", JSONBooleanType.class);
        this.jsonTypes.put("null", JSONNullType.class);
    }

    List<JSONType> getTypes(Map<String, Object> schemaTree) {
        if (schemaTree.containsKey("anyOf")) {
            ArrayList<JSONType> result = new ArrayList<JSONType>();
            List anyOf = (List)schemaTree.get("anyOf");
            for (Map any : anyOf) {
                result.addAll(this.getTypes(any));
            }
            return result;
        }
        if (schemaTree.containsKey("$ref")) {
            String schemaId = (String)schemaTree.get("$ref");
            JsonSchemaWrapper refSchema = this.schemaService.getSchema(schemaId);
            if (refSchema != null) {
                schemaTree = GraphQLSchemaProvider.buildJSONSchema(refSchema, this.schemaService).getSchemaTree();
            } else {
                System.err.println("Couldn't find schema for ref " + schemaId);
            }
        }
        if (schemaTree.containsKey("enum")) {
            ArrayList<JSONType> result = new ArrayList<JSONType>();
            result.add(new JSONEnumType(schemaTree, this));
            return result;
        }
        Object typeObject = schemaTree.get("type");
        if (typeObject == null) {
            return new ArrayList<JSONType>();
        }
        ArrayList<String> types = null;
        if (typeObject instanceof String) {
            types = new ArrayList<String>();
            types.add((String)typeObject);
        } else {
            types = (ArrayList<String>)typeObject;
        }
        ArrayList<JSONType> resultJsonTypes = new ArrayList<JSONType>();
        for (String type : types) {
            if (type == null || !this.jsonTypes.containsKey(type)) continue;
            Class<? extends JSONType> typeClass = this.jsonTypes.get(type);
            try {
                Constructor<? extends JSONType> constructor = typeClass.getConstructor(Map.class, JSONTypeFactory.class);
                resultJsonTypes.add(constructor.newInstance(schemaTree, this));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Error while building object type", (Throwable)e);
            }
        }
        return resultJsonTypes;
    }
}

