/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.servlet;

import com.fasterxml.jackson.core.type.TypeReference;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.unomi.graphql.schema.GraphQLSchemaUpdater;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.servlet.auth.GraphQLServletSecurityValidator;
import org.apache.unomi.graphql.servlet.websocket.SubscriptionWebSocketFactory;
import org.apache.unomi.graphql.utils.GraphQLObjectMapper;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={HttpServlet.class, Servlet.class}, property={"alias=/graphql"})
public class GraphQLServlet
extends WebSocketServlet {
    public static final String SCHEMA_URL = "/schema.json";
    private GraphQLSchemaUpdater graphQLSchemaUpdater;
    private ServiceManager serviceManager;
    private GraphQLServletSecurityValidator validator;
    private WebSocketServletFactory factory;

    @Reference
    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Reference
    public void setGraphQLSchemaUpdater(GraphQLSchemaUpdater graphQLSchemaUpdater) {
        this.graphQLSchemaUpdater = graphQLSchemaUpdater;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.validator = new GraphQLServletSecurityValidator();
    }

    public void configure(WebSocketServletFactory factory) {
        this.factory = factory;
        factory.setCreator((WebSocketCreator)new SubscriptionWebSocketFactory(this.graphQLSchemaUpdater.getGraphQL(), this.serviceManager));
        factory.getPolicy().setMaxTextMessageBufferSize(0x100000);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.factory.isUpgradeRequest(request, response)) {
            try {
                ServletUpgradeRequest upReq = new ServletUpgradeRequest(request);
                for (String subProtocol : upReq.getSubProtocols()) {
                    if (!subProtocol.startsWith("graphql")) continue;
                    response.addHeader("Sec-WebSocket-Protocol", subProtocol);
                    break;
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        super.service(request, response);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String query = req.getParameter("query");
        if (SCHEMA_URL.equals(req.getPathInfo())) {
            query = "\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n";
        }
        String operationName = req.getParameter("operationName");
        String variableStr = req.getParameter("variables");
        HashMap<String, Object> variables = new HashMap();
        if (variableStr != null && variableStr.trim().length() > 0) {
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            variables = (Map)GraphQLObjectMapper.getInstance().readValue(variableStr, (TypeReference)typeRef);
        }
        if (!this.validator.validate(query, operationName, req, resp)) {
            return;
        }
        this.setupCORSHeaders(req, (ServletResponse)resp);
        this.executeGraphQLRequest(resp, query, operationName, variables);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        Map body = (Map)GraphQLObjectMapper.getInstance().readValue((InputStream)req.getInputStream(), (TypeReference)typeRef);
        String query = (String)body.get("query");
        String operationName = (String)body.get("operationName");
        HashMap<String, Object> variables = (HashMap<String, Object>)body.get("variables");
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (!this.validator.validate(query, operationName, req, resp)) {
            return;
        }
        this.setupCORSHeaders(req, (ServletResponse)resp);
        this.executeGraphQLRequest(resp, query, operationName, variables);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setupCORSHeaders(req, (ServletResponse)resp);
        resp.flushBuffer();
    }

    private void executeGraphQLRequest(HttpServletResponse resp, String query, String operationName, Map<String, Object> variables) throws IOException {
        if (query == null || query.trim().length() == 0) {
            throw new IllegalArgumentException("Query cannot be empty or null");
        }
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).variables(variables).operationName(operationName).context((Object)this.serviceManager).build();
        ExecutionResult executionResult = this.graphQLSchemaUpdater.getGraphQL().execute(executionInput);
        Map specificationResult = executionResult.toSpecification();
        GraphQLObjectMapper.getInstance().writeValue(resp.getWriter(), specificationResult);
    }

    private void setupCORSHeaders(HttpServletRequest httpServletRequest, ServletResponse response) {
        if (!(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Access-Control-Allow-Origin", this.getOriginHeaderFromRequest(httpServletRequest));
        httpServletResponse.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, X-Apollo-Tracing");
        httpServletResponse.setHeader("Access-Control-Allow-Credentials", "true");
        httpServletResponse.setHeader("Access-Control-Allow-Methods", "OPTIONS, POST, GET");
    }

    private String getOriginHeaderFromRequest(HttpServletRequest httpServletRequest) {
        return httpServletRequest != null && httpServletRequest.getHeader("Origin") != null ? httpServletRequest.getHeader("Origin") : "*";
    }
}

