/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.servlet.auth;

import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.parser.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLServletSecurityValidator {
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLServletSecurityValidator.class);
    private final Parser parser = new Parser();

    public boolean validate(String query, String operationName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.isPublicOperation(query)) {
            return true;
        }
        if (req.getHeader("Authorization") == null) {
            res.addHeader("WWW-Authenticate", "Basic realm=\"karaf\"");
            res.sendError(401);
            return false;
        }
        if (this.isAuthenticatedUser(req)) {
            return true;
        }
        res.sendError(401);
        return false;
    }

    private boolean isPublicOperation(String query) {
        Document queryDoc = this.parser.parseDocument(query);
        Definition def = (Definition)queryDoc.getDefinitions().get(0);
        if (def instanceof OperationDefinition) {
            OperationDefinition opDef = (OperationDefinition)def;
            if (OperationDefinition.Operation.SUBSCRIPTION.equals((Object)opDef.getOperation())) {
                return false;
            }
            if ("IntrospectionQuery".equals(opDef.getName())) {
                return true;
            }
            List children = opDef.getSelectionSet().getChildren();
            Field cdp = children.stream().filter(node -> node instanceof Field && "cdp".equals(((Field)node).getName())).findFirst().orElse(null);
            if (cdp == null) {
                return true;
            }
            ArrayList<String> allowedNodeNames = new ArrayList<String>();
            if (OperationDefinition.Operation.QUERY.equals((Object)opDef.getOperation())) {
                allowedNodeNames.add("getProfile");
            } else if (OperationDefinition.Operation.MUTATION.equals((Object)opDef.getOperation())) {
                allowedNodeNames.add("processEvents");
            }
            return cdp.getSelectionSet().getChildren().stream().allMatch(node -> node instanceof Field && allowedNodeNames.contains(((Field)node).getName()));
        }
        return true;
    }

    private boolean isAuthenticatedUser(HttpServletRequest req) {
        req.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
        String authHeader = req.getHeader("Authorization");
        String usernameAndPassword = new String(Base64.getDecoder().decode(authHeader.substring(6).getBytes()));
        int userNameIndex = usernameAndPassword.indexOf(":");
        String username = usernameAndPassword.substring(0, userNameIndex);
        String password = usernameAndPassword.substring(userNameIndex + 1);
        try {
            boolean success;
            LoginContext loginContext = new LoginContext("karaf", callbacks -> {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(username);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
            loginContext.login();
            Subject subject = loginContext.getSubject();
            boolean bl = success = subject != null;
            if (success) {
                req.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)subject);
            }
            return success;
        }
        catch (LoginException e) {
            LOG.warn("Login failed", (Throwable)e);
            return false;
        }
    }
}

