/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.servlet.websocket;

import graphql.ExecutionResult;
import io.reactivex.subscribers.DefaultSubscriber;
import java.io.IOException;
import java.util.Collections;
import org.apache.unomi.graphql.servlet.websocket.GraphQLMessage;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResultSubscriber
extends DefaultSubscriber<ExecutionResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionResultSubscriber.class);
    private final RemoteEndpoint remote;
    private final String id;

    public ExecutionResultSubscriber(String id, RemoteEndpoint remote) {
        this.id = id;
        this.remote = remote;
    }

    public void onNext(ExecutionResult result) {
        LOGGER.debug("Subscriber sending data {}", (Object)result);
        GraphQLMessage message = GraphQLMessage.create(this.id).data(result.getData()).errors(result.getErrors()).field("dataPresent", result.isDataPresent()).build();
        this.sendMessage(message);
        this.request(1L);
    }

    private void sendMessage(GraphQLMessage message) {
        try {
            this.remote.sendString(message.toString());
        }
        catch (IOException e) {
            LOGGER.warn("Subscriber failed to send data", (Throwable)e);
        }
    }

    public void onError(Throwable t) {
        LOGGER.error("Subscriber exception", t);
        this.sendMessage(GraphQLMessage.create(this.id).errors(Collections.singletonList(t.getMessage())).build());
        this.cancel();
    }

    public void onComplete() {
        LOGGER.info("Subscriber complete");
        this.sendMessage(GraphQLMessage.complete(this.id));
        this.cancel();
    }

    public void unsubscribe() {
        this.cancel();
    }
}

