/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.servlet.websocket;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.unomi.graphql.utils.GraphQLObjectMapper;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GraphQLMessage {
    private String id;
    private String type;
    private Map<String, Object> payload;
    public static final String TYPE_CONNECTION_INIT = "connection_init";
    public static final String TYPE_CONNECTION_ACK = "connection_ack";
    public static final String TYPE_CONNECTION_ERROR = "connection_error";
    public static final String TYPE_CONNECTION_KEEP_ALIVE = "ka";
    public static final String TYPE_CONNECTION_TERMINATE = "connection_terminate";
    public static final String GQL_START = "start";
    public static final String GQL_DATA = "data";
    public static final String GQL_ERROR = "error";
    public static final String GQL_COMPLETE = "complete";
    public static final String GQL_STOP = "stop";

    private GraphQLMessage(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.payload = builder.payload;
    }

    public static GraphQLMessage fromJson(String textMessage) {
        try {
            JsonNode payloadNode;
            JsonNode node = GraphQLObjectMapper.getInstance().readTree(textMessage);
            if (node == null || node.isMissingNode()) {
                return null;
            }
            String id = node.path("id").asText(null);
            Builder builder = GraphQLMessage.create(id);
            String type = node.path("type").asText(null);
            if (type != null) {
                builder.type(type);
            }
            if (!(payloadNode = node.path("payload")).isMissingNode()) {
                Map payload = (Map)GraphQLObjectMapper.getInstance().convertValue(payloadNode, Map.class);
                payload.forEach(builder::field);
            }
            return builder.build();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static GraphQLMessage connectionAck(String id) {
        return GraphQLMessage.create(id).type(TYPE_CONNECTION_ACK).build();
    }

    public static GraphQLMessage complete(String id) {
        return GraphQLMessage.create(id).type(GQL_COMPLETE).build();
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public String toString() {
        try {
            return GraphQLObjectMapper.getInstance().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static Builder create(String id) {
        return new Builder(id);
    }

    public static class Builder {
        private String id;
        private String type;
        private Map<String, Object> payload = new HashMap<String, Object>();

        public Builder(String id) {
            this.id = id;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder errors(List<?> errors) {
            this.payload.put("errors", errors);
            if (errors != null && !errors.isEmpty()) {
                this.type = GraphQLMessage.GQL_ERROR;
            }
            return this;
        }

        public Builder data(Object data) {
            this.payload.put(GraphQLMessage.GQL_DATA, data);
            if (data != null && !GraphQLMessage.GQL_ERROR.equals(this.type)) {
                this.type = GraphQLMessage.GQL_DATA;
            }
            return this;
        }

        public Builder field(String name, Object value) {
            this.payload.put(name, value);
            return this;
        }

        public GraphQLMessage build() {
            return new GraphQLMessage(this);
        }
    }
}

