/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.servlet.websocket;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.servlet.websocket.ExecutionResultSubscriber;
import org.apache.unomi.graphql.servlet.websocket.GraphQLMessage;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionWebSocket
extends WebSocketAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionWebSocket.class);
    private GraphQL graphQL;
    private ServiceManager serviceManager;
    private Map<String, ExecutionResultSubscriber> subscriptions = new HashMap<String, ExecutionResultSubscriber>();

    public SubscriptionWebSocket(GraphQL graphQL, ServiceManager serviceManager) {
        this.graphQL = graphQL;
        this.serviceManager = serviceManager;
    }

    public void onWebSocketConnect(Session sess) {
        LOGGER.info("Opening web socket");
        super.onWebSocketConnect(sess);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        LOGGER.info("Closing web socket");
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketText(String textMessage) {
        LOGGER.info("Got web socket messages {}", (Object)textMessage);
        GraphQLMessage message = GraphQLMessage.fromJson(textMessage);
        if (message == null) {
            return;
        }
        switch (message.getType()) {
            case "connection_init": {
                this.sendMessage(GraphQLMessage.connectionAck(message.getId()));
                break;
            }
            case "start": {
                this.subscribe(message);
                break;
            }
            case "stop": {
                this.unsubscribe(message);
                break;
            }
            case "connection_terminate": {
                this.closeConnection(message, "Client terminated connection");
            }
        }
    }

    private void closeConnection(GraphQLMessage message, String reason) {
        this.unsubscribe(message);
        this.getSession().close(0, reason);
    }

    private void sendMessage(GraphQLMessage message) {
        try {
            this.getRemote().sendString(message.toString());
        }
        catch (IOException e) {
            LOGGER.error("Web socket error when sending a message", (Throwable)e);
        }
    }

    private void unsubscribe(GraphQLMessage message) {
        ExecutionResultSubscriber sub = this.subscriptions.get(message.getId());
        if (sub != null) {
            sub.unsubscribe();
            this.subscriptions.remove(message.getId());
        }
    }

    private void subscribe(GraphQLMessage message) {
        Map<String, Object> payload = message.getPayload();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query((String)payload.get("query")).variables((Map)payload.get("variables")).operationName((String)payload.get("operationName")).context((Object)this.serviceManager).build();
        ExecutionResult executionResult = this.graphQL.execute(executionInput);
        if (executionResult.getErrors() != null && !executionResult.getErrors().isEmpty()) {
            this.sendMessage(GraphQLMessage.create(message.getId()).errors(executionResult.getErrors()).build());
            this.closeConnection(message, "Error executing graphQL query");
            return;
        }
        if (!(executionResult.getData() instanceof Publisher)) {
            String error = "Fetched value should be instance of Publisher, was: " + executionResult.getClass().getName();
            this.sendMessage(GraphQLMessage.create(message.getId()).errors(Collections.singletonList(error)).build());
            this.closeConnection(message, error);
            return;
        }
        Publisher publisher = (Publisher)executionResult.getData();
        ExecutionResultSubscriber subscriber = new ExecutionResultSubscriber(message.getId(), this.getRemote());
        publisher.subscribe((Subscriber)subscriber);
        this.subscriptions.put(message.getId(), subscriber);
    }
}

