/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.input;

import graphql.annotations.annotationTypes.GraphQLName;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.graphql.types.input.BaseProfileEventProcessor;

@GraphQLName(value="CDP_ProfileUpdateEventInput")
public class CDPProfileUpdateEventInput
extends BaseProfileEventProcessor {
    public static final String TYPE_NAME = "CDP_ProfileUpdateEventInput";
    public static final String EVENT_NAME = "cdp_profileUpdateEvent";

    @Override
    public Event buildEvent(LinkedHashMap<String, Object> eventInputAsMap, DataFetchingEnvironment environment) {
        Profile profile = this.loadProfile(eventInputAsMap, environment);
        if (profile == null) {
            return null;
        }
        LinkedHashMap profilePropertiesAsMap = (LinkedHashMap)eventInputAsMap.get(EVENT_NAME);
        Map persistedProperties = profile.getProperties();
        HashSet propertiesToDelete = new HashSet(persistedProperties.keySet());
        propertiesToDelete.removeAll(profilePropertiesAsMap.keySet());
        HashMap<String, Object> propertiesToAdd = new HashMap<String, Object>();
        HashMap<String, Object> propertiesToUpdate = new HashMap<String, Object>();
        profilePropertiesAsMap.forEach((key, value) -> {
            if (persistedProperties.containsKey(key)) {
                if (!Objects.equals(persistedProperties.get(key), profilePropertiesAsMap.get(key))) {
                    propertiesToUpdate.put("properties." + key, value);
                }
            } else {
                propertiesToAdd.put("properties." + key, value);
            }
        });
        return this.eventBuilder(profile).setPersistent(true).setPropertiesToAdd(propertiesToAdd).setPropertiesToUpdate(propertiesToUpdate).setPropertiesToDelete(propertiesToDelete.stream().map(prop -> "properties." + prop).collect(Collectors.toList())).build();
    }

    @Override
    public String getFieldName() {
        return EVENT_NAME;
    }
}

