/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.input.property;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLPrettify;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.query.NumericRange;

public abstract class BaseCDPPropertyInput {
    private String name;
    private Integer minOccurrences;
    private Integer maxOccurrences;
    private List<String> tags;

    public BaseCDPPropertyInput(@GraphQLName(value="name") String name, @GraphQLName(value="minOccurrences") Integer minOccurrences, @GraphQLName(value="maxOccurrences") Integer maxOccurrences, @GraphQLName(value="tags") List<String> tags) {
        this.name = name;
        this.minOccurrences = minOccurrences;
        this.maxOccurrences = maxOccurrences;
        this.tags = tags;
    }

    public BaseCDPPropertyInput(BaseCDPPropertyInput input) {
        this.name = input.name;
        this.minOccurrences = input.minOccurrences;
        this.maxOccurrences = input.maxOccurrences;
        this.tags = input.tags;
    }

    @GraphQLNonNull
    @GraphQLField
    @GraphQLPrettify
    public @GraphQLID @GraphQLNonNull String getName() {
        return this.name;
    }

    @GraphQLField
    @GraphQLPrettify
    public Integer getMinOccurrences() {
        return this.minOccurrences;
    }

    @GraphQLField
    @GraphQLPrettify
    public Integer getMaxOccurrences() {
        return this.maxOccurrences;
    }

    @GraphQLField
    @GraphQLPrettify
    public List<String> getTags() {
        return this.tags;
    }

    public abstract String getCDPPropertyType();

    public void updateType(PropertyType propertyType) {
        if (propertyType == null) {
            return;
        }
        if ("set".equals(propertyType.getValueTypeId()) && !this.getCDPPropertyType().equals(propertyType.getValueTypeId())) {
            propertyType.setChildPropertyTypes(Collections.emptySet());
        }
        propertyType.setTarget("profiles");
        propertyType.setItemId(this.name);
        propertyType.setValueTypeId(this.getCDPPropertyType());
        propertyType.setMetadata(this.updateMetadata(propertyType.getMetadata()));
        propertyType.setMultivalued(Boolean.valueOf(this.maxOccurrences != null && this.maxOccurrences > 1));
    }

    public PropertyType toPropertyType() {
        PropertyType type = new PropertyType();
        this.updateType(type);
        return type;
    }

    private Metadata updateMetadata(Metadata metadata) {
        if (metadata == null) {
            metadata = new Metadata();
            HashSet<String> systemTags = new HashSet<String>();
            systemTags.add("profileProperties");
            systemTags.add("properties");
            systemTags.add("systemProfileProperties");
            metadata.setSystemTags(systemTags);
        }
        metadata.setId(this.name);
        metadata.setName(this.name);
        metadata.setTags((Set)(this.tags != null ? new HashSet<String>(this.tags) : Collections.emptySet()));
        return metadata;
    }

    protected void updateDefaultNumericRange(PropertyType type, Double from, Double to) {
        if (type == null) {
            return;
        }
        NumericRange defaultRange = new NumericRange();
        defaultRange.setKey("defaultRange");
        List ranges = type.getNumericRanges();
        if (ranges == null || ranges.isEmpty()) {
            type.setNumericRanges(Collections.singletonList(defaultRange));
        } else {
            defaultRange = ranges.stream().filter(range -> "defaultRange".equals(range.getKey())).findFirst().orElse(defaultRange);
        }
        defaultRange.setFrom(from);
        defaultRange.setTo(to);
    }

    protected void deleteDefaultNumericRange(PropertyType type) {
        if (type == null || type.getNumericRanges() == null) {
            return;
        }
        type.setNumericRanges(type.getNumericRanges().stream().filter(range -> !"defaultRange".equals(range.getKey())).collect(Collectors.toList()));
    }
}

