/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.input.property;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLPrettify;
import java.util.List;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.graphql.types.input.property.BaseCDPPropertyInput;

@GraphQLName(value="CDP_FloatPropertyInput")
public class CDPFloatPropertyInput
extends BaseCDPPropertyInput {
    private Double minValue;
    private Double maxValue;
    private Double defaultValue;

    public CDPFloatPropertyInput(@GraphQLName(value="name") String name, @GraphQLName(value="minOccurrences") Integer minOccurrences, @GraphQLName(value="maxOccurrences") Integer maxOccurrences, @GraphQLName(value="tags") List<String> tags, @GraphQLName(value="minValue") Double minValue, @GraphQLName(value="maxValue") Double maxValue, @GraphQLName(value="defaultValue") Double defaultValue) {
        super(name, minOccurrences, maxOccurrences, tags);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
    }

    @GraphQLField
    @GraphQLPrettify
    public Double getMinValue() {
        return this.minValue;
    }

    @GraphQLField
    @GraphQLPrettify
    public Double getMaxValue() {
        return this.maxValue;
    }

    @GraphQLField
    @GraphQLPrettify
    public Double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getCDPPropertyType() {
        return "float";
    }

    @Override
    public void updateType(PropertyType type) {
        if (type == null) {
            return;
        }
        super.updateType(type);
        type.setDefaultValue(this.defaultValue != null ? this.defaultValue.toString() : null);
        if (this.minValue != null || this.maxValue != null) {
            Double to = this.maxValue != null && (this.minValue == null || this.maxValue >= this.minValue) ? this.maxValue : null;
            this.updateDefaultNumericRange(type, this.minValue, to);
        } else {
            this.deleteDefaultNumericRange(type);
        }
    }
}

