/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.input.property;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLPrettify;
import java.util.List;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.graphql.types.input.property.BaseCDPPropertyInput;

@GraphQLName(value="CDP_LongPropertyInput")
public class CDPLongPropertyInput
extends BaseCDPPropertyInput {
    private Long minValue;
    private Long maxValue;
    private Long defaultValue;

    public CDPLongPropertyInput(@GraphQLName(value="name") String name, @GraphQLName(value="minOccurrences") Integer minOccurrences, @GraphQLName(value="maxOccurrences") Integer maxOccurrences, @GraphQLName(value="tags") List<String> tags, @GraphQLName(value="minValue") Long minValue, @GraphQLName(value="maxValue") Long maxValue, @GraphQLName(value="defaultValue") Long defaultValue) {
        super(name, minOccurrences, maxOccurrences, tags);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
    }

    @GraphQLField
    @GraphQLPrettify
    public Long getMinValue() {
        return this.minValue;
    }

    @GraphQLField
    @GraphQLPrettify
    public Long getMaxValue() {
        return this.maxValue;
    }

    @GraphQLField
    @GraphQLPrettify
    public Long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getCDPPropertyType() {
        return "long";
    }

    @Override
    public void updateType(PropertyType type) {
        if (type == null) {
            return;
        }
        super.updateType(type);
        type.setDefaultValue(this.defaultValue != null ? this.defaultValue.toString() : null);
        if (this.minValue != null || this.maxValue != null) {
            Double from = this.minValue != null ? Double.valueOf(this.minValue.doubleValue()) : null;
            Double to = this.maxValue != null && (this.minValue == null || this.maxValue >= this.minValue) ? Double.valueOf(this.maxValue.doubleValue()) : null;
            this.updateDefaultNumericRange(type, from, to);
        } else {
            this.deleteDefaultNumericRange(type);
        }
    }
}

