/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.time.OffsetDateTime;
import org.apache.unomi.api.Consent;
import org.apache.unomi.graphql.fetchers.consent.ConsentEventConnectionDataFetcher;
import org.apache.unomi.graphql.types.output.CDPClient;
import org.apache.unomi.graphql.types.output.CDPConsentStatus;
import org.apache.unomi.graphql.types.output.CDPEventConnection;
import org.apache.unomi.graphql.types.output.CDPProfileInterface;
import org.apache.unomi.graphql.types.output.CDPSource;
import org.apache.unomi.graphql.utils.DateUtils;

@GraphQLName(value="CDP_Consent")
@GraphQLDescription(value="CDP_Consent represents a persisted Consent, always attached to a specific profile.")
public class CDPConsent {
    private String token;
    private Consent consent;

    public CDPConsent(String token, Consent consent) {
        this.token = token;
        this.consent = consent;
    }

    public String getToken() {
        return this.token;
    }

    @GraphQLField
    public @GraphQLID @GraphQLNonNull String token() {
        return this.token;
    }

    @GraphQLField
    public CDPSource source() {
        return this.consent != null ? new CDPSource(this.consent.getScope()) : null;
    }

    @GraphQLField
    public CDPClient client() {
        return CDPClient.DEFAULT;
    }

    @GraphQLField
    public String type() {
        return this.consent != null ? this.consent.getTypeIdentifier() : null;
    }

    @GraphQLField
    public CDPConsentStatus status() {
        return this.consent != null ? CDPConsentStatus.from(this.consent.getStatus()) : null;
    }

    @GraphQLField
    public OffsetDateTime lastUpdate() {
        return this.consent != null ? DateUtils.toOffsetDateTime(this.consent.getStatusDate()) : null;
    }

    @GraphQLField
    public OffsetDateTime expiration() {
        return this.consent != null ? DateUtils.toOffsetDateTime(this.consent.getRevokeDate()) : null;
    }

    @GraphQLField
    public CDPProfileInterface profile() {
        return null;
    }

    @GraphQLField
    public CDPEventConnection events(DataFetchingEnvironment environment) throws Exception {
        return new ConsentEventConnectionDataFetcher().get(environment);
    }
}

