/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.time.OffsetDateTime;
import java.util.Map;
import org.apache.unomi.api.Event;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.utils.DateUtils;

@GraphQLName(value="CDP_ConsentUpdateEvent")
@GraphQLDescription(value="Standard EventType to create or update Consents.")
public class CDPConsentUpdateEvent
implements CDPEventInterface {
    public static final String TYPE_NAME = "CDP_ConsentUpdateEvent";
    private final Event event;

    public CDPConsentUpdateEvent(Event event) {
        this.event = event;
    }

    @Override
    public Event getEvent() {
        return this.event;
    }

    @GraphQLField
    @GraphQLNonNull
    public String type(DataFetchingEnvironment environment) {
        Object type = this.getEvent().getProperty("type");
        return type != null ? type.toString() : null;
    }

    @GraphQLField
    public String status(DataFetchingEnvironment environment) {
        Object status = this.getEvent().getProperty("status");
        return status != null ? status.toString() : null;
    }

    @GraphQLField
    public OffsetDateTime lastUpdate(DataFetchingEnvironment environment) {
        Object lastUpdate = this.getEvent().getProperty("lastUpdate");
        return lastUpdate != null ? DateUtils.offsetDateTimeFromMap((Map)lastUpdate) : null;
    }

    @GraphQLField
    public OffsetDateTime expiration(DataFetchingEnvironment environment) {
        Object expiration = this.getEvent().getProperty("expiration");
        return expiration != null ? DateUtils.offsetDateTimeFromMap((Map)expiration) : null;
    }
}

