/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.schema.DataFetchingEnvironment;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.GeoPoint;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPClient;
import org.apache.unomi.graphql.types.output.CDPObject;
import org.apache.unomi.graphql.types.output.CDPProfile;
import org.apache.unomi.graphql.types.output.CDPProfileID;
import org.apache.unomi.graphql.types.output.CDPSource;
import org.apache.unomi.graphql.types.output.CDPTopic;
import org.apache.unomi.graphql.types.resolvers.CDPEventInterfaceResolver;
import org.apache.unomi.graphql.utils.DateUtils;

@GraphQLName(value="CDP_EventInterface")
@GraphQLTypeResolver(value=CDPEventInterfaceResolver.class)
@GraphQLDescription(value="An event could be anything from someone clicking a link, to performing a transaction or consenting to use of his/hers information. Events are streamed or delivered from authorized Clients to the Customer Data Platform.")
public interface CDPEventInterface {
    public static final String TYPE_NAME = "CDP_EventInterface";

    public Event getEvent();

    default public Object getProperty(String propertyName) {
        return this.getEvent() != null ? this.getEvent().getProperty(propertyName) : null;
    }

    @GraphQLNonNull
    @GraphQLField
    default public @GraphQLID @GraphQLNonNull String id(DataFetchingEnvironment environment) {
        return this.getEvent().getItemId();
    }

    @GraphQLField
    default public CDPSource cdp_source(DataFetchingEnvironment environment) {
        return null;
    }

    @GraphQLField
    default public CDPClient cdp_client(DataFetchingEnvironment environment) {
        return CDPClient.DEFAULT;
    }

    @GraphQLField
    @GraphQLNonNull
    default public CDPProfileID cdp_profileID(DataFetchingEnvironment environment) {
        return new CDPProfileID(this.getEvent().getProfileId());
    }

    @GraphQLField
    @GraphQLNonNull
    default public CDPProfile cdp_profile(DataFetchingEnvironment environment) {
        if (this.getEvent().getProfile() != null) {
            return new CDPProfile(this.getEvent().getProfile());
        }
        if (this.getEvent().getProfileId() != null) {
            ServiceManager serviceManager = (ServiceManager)environment.getContext();
            Profile profile = serviceManager.getService(ProfileService.class).load(this.getEvent().getProfileId());
            return new CDPProfile(profile);
        }
        return null;
    }

    @GraphQLField
    default public CDPObject cdp_object(DataFetchingEnvironment environment) {
        return new CDPObject(this.getEvent());
    }

    @GraphQLField
    default public GeoPoint cdp_location(DataFetchingEnvironment environment) {
        return null;
    }

    @GraphQLField
    default public OffsetDateTime cdp_timestamp(DataFetchingEnvironment environment) {
        return DateUtils.toOffsetDateTime(this.getEvent().getTimeStamp());
    }

    @GraphQLField
    default public List<CDPTopic> cdp_topics(DataFetchingEnvironment environment) {
        return null;
    }
}

