/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.api.lists.UserList;
import org.apache.unomi.graphql.fetchers.list.ListProfileConnectionDataFetcher;
import org.apache.unomi.graphql.types.output.CDPProfileConnection;
import org.apache.unomi.graphql.types.output.CDPView;

@GraphQLName(value="CDP_List")
@GraphQLDescription(value="Lists are explicitly created and named in the Customer Data Platform. Profiles may then be added to a list, and later opt out if desired.")
public class CDPList {
    public static final String TYPE_NAME = "CDP_List";
    private UserList userList;

    public CDPList(UserList userList) {
        this.userList = userList;
    }

    @GraphQLField
    public @GraphQLID @GraphQLNonNull String id() {
        return this.userList.getItemId();
    }

    @GraphQLField
    @GraphQLNonNull
    public CDPView view() {
        return this.userList.getScope() != null ? new CDPView(this.userList.getScope()) : null;
    }

    @GraphQLField
    @GraphQLNonNull
    public String name() {
        return this.userList.getMetadata() != null ? this.userList.getMetadata().getName() : null;
    }

    @GraphQLField
    public CDPProfileConnection active(@GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, DataFetchingEnvironment environment) throws Exception {
        return new ListProfileConnectionDataFetcher().get(environment);
    }

    @GraphQLField
    public CDPProfileConnection inactive(@GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before) {
        return new CDPProfileConnection();
    }
}

