/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.graphql.converters.UserListConverter;
import org.apache.unomi.graphql.types.output.CDPListEdge;
import org.apache.unomi.graphql.types.output.CDPPageInfo;

@GraphQLName(value="CDP_ListConnection")
public class CDPListConnection {
    public static final String TYPE_NAME = "CDP_ListConnection";
    private final PartialList<Metadata> userLists;

    public CDPListConnection(PartialList<Metadata> userLists) {
        this.userLists = userLists;
    }

    @GraphQLField
    public Integer totalCount(DataFetchingEnvironment environment) {
        return this.userLists != null ? Integer.valueOf((int)this.userLists.getTotalSize()) : null;
    }

    @GraphQLField
    public List<CDPListEdge> edges(DataFetchingEnvironment environment) {
        if (this.userLists == null) {
            return null;
        }
        return this.userLists.getList().stream().map(UserListConverter::convertToUnomiList).map(CDPListEdge::new).collect(Collectors.toList());
    }

    @GraphQLField
    public CDPPageInfo pageInfo(DataFetchingEnvironment environment) {
        if (this.userLists == null) {
            return null;
        }
        return new CDPPageInfo(this.userLists.getOffset() > 0L, this.userLists.getTotalSize() > (long)this.userLists.getList().size());
    }
}

