/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.graphql.condition.factories.ConditionFactory;
import org.apache.unomi.graphql.converters.UserListConverter;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.types.output.CDPList;
import org.apache.unomi.services.UserListService;

@GraphQLName(value="CDP_ListsUpdateEvent")
@GraphQLDescription(value="Standard Event to update profile membership for specified lists.")
public class CDPListsUpdateEvent
implements CDPEventInterface {
    public static final String TYPE_NAME = "CDP_ListsUpdateEvent";
    private final Event event;

    public CDPListsUpdateEvent(Event event) {
        this.event = event;
    }

    @Override
    public Event getEvent() {
        return this.event;
    }

    @GraphQLField
    public List<CDPList> joinLists(DataFetchingEnvironment environment) {
        return this.createResult("joinLists", environment);
    }

    @GraphQLField
    public List<CDPList> leaveLists(DataFetchingEnvironment environment) {
        return this.createResult("leaveLists", environment);
    }

    private List<CDPList> createResult(String propertyName, DataFetchingEnvironment environment) {
        List listIds = (List)this.getProperty(propertyName);
        if (listIds == null || listIds.isEmpty()) {
            return null;
        }
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ConditionFactory factory = new ConditionFactory("userListPropertyCondition", environment);
        Query query = new Query();
        query.setCondition(factory.propertiesCondition("itemId", "in", listIds));
        PartialList partialList = serviceManager.getService(UserListService.class).getListMetadatas(query);
        if (partialList == null || partialList.getList() == null) {
            return null;
        }
        return partialList.getList().stream().map(UserListConverter::convertToUnomiList).map(CDPList::new).collect(Collectors.toList());
    }
}

