/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.graphql.fetchers.profile.ProfileConsentsDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileInterestsDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileListsDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileSegmentsDataFetcher;
import org.apache.unomi.graphql.types.output.CDPConsent;
import org.apache.unomi.graphql.types.output.CDPInterest;
import org.apache.unomi.graphql.types.output.CDPList;
import org.apache.unomi.graphql.types.output.CDPProfileID;
import org.apache.unomi.graphql.types.output.CDPProfileInterface;
import org.apache.unomi.graphql.types.output.CDPSegment;
import org.apache.unomi.graphql.types.output.CDPView;

@GraphQLName(value="CDP_Persona")
@GraphQLDescription(value="A persona is a concept used to personify your audience. This may for instance be used to test personalization and targeting of content in a 3rd party system.")
public class CDPPersona
implements CDPProfileInterface {
    public static final String TYPE_NAME = "CDP_Persona";
    private Persona persona;

    public CDPPersona(Persona persona) {
        this.persona = persona;
    }

    @GraphQLField
    public @GraphQLID String id() {
        return this.persona != null ? this.persona.getItemId() : null;
    }

    @GraphQLField
    @GraphQLNonNull
    public String cdp_name() {
        return this.persona != null ? (String)this.persona.getProperty("cdp_name") : null;
    }

    @GraphQLField
    @GraphQLNonNull
    public CDPView cdp_view() {
        if (this.persona == null) {
            return null;
        }
        Object view = this.persona.getProperty("cdp_view");
        return view != null ? new CDPView(view.toString()) : null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.persona != null ? this.persona.getProperty(propertyName) : null;
    }

    @Override
    @GraphQLField
    public List<CDPProfileID> cdp_profileIDs(DataFetchingEnvironment environment) throws Exception {
        if (this.persona == null) {
            return null;
        }
        List profileIds = (List)this.persona.getProperty("mergedWith");
        return profileIds != null ? profileIds.stream().map(CDPProfileID::new).collect(Collectors.toList()) : null;
    }

    @Override
    @GraphQLField
    public List<CDPSegment> cdp_segments(@GraphQLName(value="views") List<String> viewIds, DataFetchingEnvironment environment) throws Exception {
        return this.persona != null ? new ProfileSegmentsDataFetcher((Profile)this.persona, viewIds).get(environment) : null;
    }

    @Override
    @GraphQLField
    public List<CDPInterest> cdp_interests(@GraphQLName(value="views") List<String> viewIds, DataFetchingEnvironment environment) throws Exception {
        return this.persona != null ? new ProfileInterestsDataFetcher((Profile)this.persona, viewIds).get(environment) : null;
    }

    @Override
    @GraphQLField
    public List<CDPConsent> cdp_consents(DataFetchingEnvironment environment) throws Exception {
        return this.persona != null ? new ProfileConsentsDataFetcher((Profile)this.persona).get(environment) : null;
    }

    @Override
    public List<CDPList> cdp_lists(@GraphQLName(value="views") List<String> viewIds, DataFetchingEnvironment environment) throws Exception {
        return this.persona != null ? new ProfileListsDataFetcher((Profile)this.persona, viewIds).get(environment) : null;
    }

    public Persona getPersona() {
        return this.persona;
    }
}

