/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.unomi.api.Profile;
import org.apache.unomi.graphql.fetchers.profile.ProfileAllEventsConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileConsentsDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileIdsDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileInterestsDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileLastEventsConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileListsDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileMatchesDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileSegmentsDataFetcher;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPNamedFilterInput;
import org.apache.unomi.graphql.types.input.CDPOptimizationInput;
import org.apache.unomi.graphql.types.input.CDPProfileIDInput;
import org.apache.unomi.graphql.types.input.CDPRecommendationInput;
import org.apache.unomi.graphql.types.output.CDPConsent;
import org.apache.unomi.graphql.types.output.CDPEventConnection;
import org.apache.unomi.graphql.types.output.CDPFilterMatch;
import org.apache.unomi.graphql.types.output.CDPInterest;
import org.apache.unomi.graphql.types.output.CDPList;
import org.apache.unomi.graphql.types.output.CDPOptimizationResult;
import org.apache.unomi.graphql.types.output.CDPProfileID;
import org.apache.unomi.graphql.types.output.CDPProfileInterface;
import org.apache.unomi.graphql.types.output.CDPRecommendationResult;
import org.apache.unomi.graphql.types.output.CDPSegment;

@GraphQLName(value="CDP_Profile")
@GraphQLDescription(value=" The Customer Data Platform dynamically creates and build profiles from events that occur over time. A Profile can be created from an anonymous visitor on a webpage, populated from an identity system, a CRM, or the combination of all of them.")
public class CDPProfile
implements CDPProfileInterface {
    public static final String TYPE_NAME = "CDP_Profile";
    private final Profile profile;

    public CDPProfile(Profile profile) {
        this.profile = profile;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.profile != null ? this.profile.getProperty(propertyName) : null;
    }

    @Override
    @GraphQLField
    public List<CDPProfileID> cdp_profileIDs(DataFetchingEnvironment environment) throws Exception {
        return new ProfileIdsDataFetcher(this.profile).get(environment);
    }

    @Override
    @GraphQLField
    public List<CDPSegment> cdp_segments(@GraphQLName(value="views") List<String> viewIds, DataFetchingEnvironment environment) throws Exception {
        return new ProfileSegmentsDataFetcher(this.profile, viewIds).get(environment);
    }

    @Override
    @GraphQLField
    public List<CDPInterest> cdp_interests(@GraphQLName(value="views") List<String> viewIds, DataFetchingEnvironment environment) throws Exception {
        return new ProfileInterestsDataFetcher(this.profile, viewIds).get(environment);
    }

    @Override
    @GraphQLField
    public List<CDPConsent> cdp_consents(DataFetchingEnvironment environment) throws Exception {
        return new ProfileConsentsDataFetcher(this.profile).get(environment);
    }

    @Override
    @GraphQLField
    public List<CDPList> cdp_lists(@GraphQLName(value="views") List<String> viewIds, DataFetchingEnvironment environment) throws Exception {
        return new ProfileListsDataFetcher(this.profile, viewIds).get(environment);
    }

    @GraphQLField
    public CDPEventConnection cdp_events(@GraphQLName(value="filter") CDPEventFilterInput filterInput, @GraphQLName(value="first") Integer first, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, @GraphQLName(value="after") String after, DataFetchingEnvironment environment) throws Exception {
        return new ProfileAllEventsConnectionDataFetcher(this.profile, filterInput).get(environment);
    }

    @GraphQLField
    public CDPEventConnection cdp_lastEvents(@GraphQLName(value="profileID") CDPProfileIDInput profileID, @GraphQLName(value="count") Integer count, DataFetchingEnvironment environment) throws Exception {
        return new ProfileLastEventsConnectionDataFetcher(this.profile, count).get(environment);
    }

    @GraphQLField
    public List<CDPFilterMatch> cdp_matches(@GraphQLName(value="namedFilters") List<CDPNamedFilterInput> namedFilters, DataFetchingEnvironment environment) throws Exception {
        return new ProfileMatchesDataFetcher(this.profile, namedFilters).get(environment);
    }

    @GraphQLField
    public List<CDPOptimizationResult> cdp_optimize(@GraphQLName(value="parameters") Collection<CDPOptimizationInput> parameters) {
        return Collections.emptyList();
    }

    @GraphQLField
    public List<CDPRecommendationResult> cdp_recommend(@GraphQLName(value="parameters") Collection<CDPRecommendationInput> parameters) {
        return Collections.emptyList();
    }

    public Profile getProfile() {
        return this.profile;
    }
}

