/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.apache.unomi.api.ProfileAlias;
import org.apache.unomi.graphql.types.output.CDPClient;
import org.apache.unomi.graphql.types.output.CDPProfileID;

@GraphQLName(value="CDP_ProfileAlias")
@GraphQLDescription(value="Alias for Profile.")
public class CDPProfileAlias {
    public static final String TYPE_NAME = "CDP_ProfileAlias";
    private final ProfileAlias profileAlias;

    public CDPProfileAlias(ProfileAlias profileAlias) {
        this.profileAlias = profileAlias;
    }

    @GraphQLField
    public String alias() {
        return this.profileAlias != null ? this.profileAlias.getItemId() : null;
    }

    @GraphQLField
    public CDPProfileID profileID() {
        if (this.profileAlias != null) {
            CDPProfileID profileID = new CDPProfileID(this.profileAlias.getProfileID());
            if (this.profileAlias.getClientID() != null) {
                profileID.setClient(new CDPClient(this.profileAlias.getClientID(), this.profileAlias.getClientID()));
            }
            return profileID;
        }
        return null;
    }

    @GraphQLField
    public OffsetDateTime creationTime() {
        return this.profileAlias != null ? this.profileAlias.getCreationTime().toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime() : null;
    }

    @GraphQLField
    public OffsetDateTime modifiedTime() {
        return this.profileAlias != null ? this.profileAlias.getModifiedTime().toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime() : null;
    }
}

