/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import java.util.Set;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.graphql.types.resolvers.CDPPropertyInterfaceResolver;

@GraphQLName(value="CDP_PropertyInterface")
@GraphQLTypeResolver(value=CDPPropertyInterfaceResolver.class)
@GraphQLDescription(value="The property interface defines the common fields for the different value types.")
public interface CDPPropertyInterface {
    public static final String TYPE_NAME = "CDP_PropertyInterface";

    public PropertyType getType();

    @GraphQLNonNull
    @GraphQLField
    default public @GraphQLID @GraphQLNonNull String name() {
        PropertyType type = this.getType();
        if (type == null) {
            return null;
        }
        Metadata meta = type.getMetadata();
        return meta != null ? meta.getName() : null;
    }

    @GraphQLField
    default public Integer minOccurrences() {
        return 0;
    }

    @GraphQLField
    default public Integer maxOccurrences() {
        PropertyType type = this.getType();
        if (type == null) {
            return null;
        }
        boolean multi = type.isMultivalued() != null && type.isMultivalued() != false;
        return multi ? 1000 : 1;
    }

    @GraphQLField
    default public Set<String> tags() {
        PropertyType type = this.getType();
        if (type == null) {
            return null;
        }
        Metadata meta = type.getMetadata();
        return meta != null ? meta.getTags() : null;
    }
}

