/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.apache.unomi.graphql.fetchers.FindTopicsConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.SourceDataFetcher;
import org.apache.unomi.graphql.fetchers.TopicDataFetcher;
import org.apache.unomi.graphql.fetchers.ViewDataFetcher;
import org.apache.unomi.graphql.fetchers.event.EventDataFetcher;
import org.apache.unomi.graphql.fetchers.event.FindEventsConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.list.GetListDataFetcher;
import org.apache.unomi.graphql.fetchers.list.ListConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.FindProfileAliasConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.FindProfilesConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.GetProfileAliasesDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileAliasDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.ProfileDataFetcher;
import org.apache.unomi.graphql.fetchers.profile.PropertiesConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.segment.FindSegmentsConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.segment.SegmentDataFetcher;
import org.apache.unomi.graphql.fetchers.segment.UnomiSegmentDataFetcher;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPListFilterInput;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;
import org.apache.unomi.graphql.types.input.CDPProfileAliasFilterInput;
import org.apache.unomi.graphql.types.input.CDPProfileFilterInput;
import org.apache.unomi.graphql.types.input.CDPProfileIDInput;
import org.apache.unomi.graphql.types.input.CDPSegmentFilterInput;
import org.apache.unomi.graphql.types.input.CDPTopicFilterInput;
import org.apache.unomi.graphql.types.output.CDPEventConnection;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.types.output.CDPList;
import org.apache.unomi.graphql.types.output.CDPListConnection;
import org.apache.unomi.graphql.types.output.CDPProfile;
import org.apache.unomi.graphql.types.output.CDPProfileAlias;
import org.apache.unomi.graphql.types.output.CDPProfileAliasConnection;
import org.apache.unomi.graphql.types.output.CDPProfileConnection;
import org.apache.unomi.graphql.types.output.CDPPropertyConnection;
import org.apache.unomi.graphql.types.output.CDPSegment;
import org.apache.unomi.graphql.types.output.CDPSegmentConnection;
import org.apache.unomi.graphql.types.output.CDPSource;
import org.apache.unomi.graphql.types.output.CDPTopic;
import org.apache.unomi.graphql.types.output.CDPTopicConnection;
import org.apache.unomi.graphql.types.output.CDPView;
import org.apache.unomi.graphql.types.output.UnomiSegment;

@GraphQLName(value="CDP_Query")
public class CDPQuery {
    public static final String TYPE_NAME = "CDP_Query";

    @GraphQLField
    public CDPProfile getProfile(@GraphQLName(value="profileID") @GraphQLNonNull CDPProfileIDInput profileID, @GraphQLName(value="createIfMissing") Boolean createIfMissing, DataFetchingEnvironment environment) throws Exception {
        return new ProfileDataFetcher(profileID, createIfMissing).get(environment);
    }

    @GraphQLField
    public CDPProfileConnection findProfiles(@GraphQLName(value="filter") CDPProfileFilterInput filter, @GraphQLName(value="orderBy") List<CDPOrderByInput> orderBy, @GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, @GraphQLName(value="unomi_text") @GraphQLDescription(value="The text that the item must have in one of its fields to be considered a match") String text, DataFetchingEnvironment environment) throws Exception {
        return new FindProfilesConnectionDataFetcher(filter, orderBy).get(environment);
    }

    @GraphQLField
    public CDPPropertyConnection getProfileProperties(@GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, DataFetchingEnvironment environment) throws Exception {
        return new PropertiesConnectionDataFetcher().get(environment);
    }

    @GraphQLField
    public CDPEventConnection findEvents(@GraphQLName(value="filter") CDPEventFilterInput filter, @GraphQLName(value="orderBy") List<CDPOrderByInput> orderBy, @GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, @GraphQLName(value="unomi_text") @GraphQLDescription(value="The text that the item must have in one of its fields to be considered a match") String text, DataFetchingEnvironment environment) {
        return new FindEventsConnectionDataFetcher(filter, orderBy).get(environment);
    }

    @GraphQLField
    public CDPEventInterface getEvent(@GraphQLNonNull @GraphQLName(value="id") String id, DataFetchingEnvironment environment) throws Exception {
        return new EventDataFetcher(id).get(environment);
    }

    @GraphQLField
    public CDPSegmentConnection findSegments(@GraphQLName(value="filter") CDPSegmentFilterInput filter, @GraphQLName(value="orderBy") List<CDPOrderByInput> orderBy, @GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, DataFetchingEnvironment environment) {
        return new FindSegmentsConnectionDataFetcher(filter, orderBy).get(environment);
    }

    @GraphQLField
    public CDPSegment getSegment(@GraphQLName(value="segmentID") @GraphQLID String segmentId, DataFetchingEnvironment environment) throws Exception {
        return new SegmentDataFetcher(segmentId).get(environment);
    }

    @GraphQLField
    public UnomiSegment getUnomiSegment(@GraphQLName(value="segmentID") @GraphQLID String segmentId, DataFetchingEnvironment environment) throws Exception {
        return new UnomiSegmentDataFetcher(segmentId).get(environment);
    }

    @GraphQLField
    public List<CDPView> getViews(DataFetchingEnvironment environment) throws Exception {
        return new ViewDataFetcher().get(environment);
    }

    @GraphQLField
    public CDPTopic getTopic(@GraphQLName(value="topicID") @GraphQLID String topicId, DataFetchingEnvironment environment) throws Exception {
        return new TopicDataFetcher(topicId).get(environment);
    }

    @GraphQLField
    public CDPTopicConnection findTopics(@GraphQLName(value="filter") CDPTopicFilterInput filterInput, @GraphQLName(value="orderBy") List<CDPOrderByInput> orderByInput, @GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, DataFetchingEnvironment environment) throws Exception {
        return new FindTopicsConnectionDataFetcher(filterInput, orderByInput).get(environment);
    }

    @GraphQLField
    public List<CDPSource> getSources(DataFetchingEnvironment environment) throws Exception {
        return new SourceDataFetcher().get(environment);
    }

    @GraphQLField
    public CDPList getList(@GraphQLName(value="listID") @GraphQLID String listId, DataFetchingEnvironment environment) throws Exception {
        return new GetListDataFetcher(listId).get(environment);
    }

    @GraphQLField
    public CDPListConnection findLists(@GraphQLName(value="filter") CDPListFilterInput filterInput, @GraphQLName(value="orderBy") List<CDPOrderByInput> orderByInput, @GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, DataFetchingEnvironment environment) throws Exception {
        return new ListConnectionDataFetcher(filterInput, orderByInput).get(environment);
    }

    @GraphQLField
    public CDPProfileAlias getProfileAlias(@GraphQLNonNull @GraphQLName(value="alias") @GraphQLID @GraphQLNonNull String alias, DataFetchingEnvironment environment) throws Exception {
        return new ProfileAliasDataFetcher(alias).get(environment);
    }

    @GraphQLField
    public List<CDPProfileAlias> getProfileAliases(@GraphQLName(value="profileID") @GraphQLID @GraphQLNonNull String profileID, DataFetchingEnvironment environment) throws Exception {
        return new GetProfileAliasesDataFetcher(profileID).get(environment);
    }

    @GraphQLField
    public CDPProfileAliasConnection findProfileAliases(@GraphQLName(value="filter") CDPProfileAliasFilterInput filterInput, @GraphQLName(value="orderBy") List<CDPOrderByInput> orderByInput, @GraphQLName(value="first") Integer first, @GraphQLName(value="after") String after, @GraphQLName(value="last") Integer last, @GraphQLName(value="before") String before, DataFetchingEnvironment environment) throws Exception {
        return new FindProfileAliasConnectionDataFetcher(filterInput, orderByInput).get(environment);
    }
}

