/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.graphql.condition.parsers.SegmentConditionParser;
import org.apache.unomi.graphql.types.output.CDPView;

@GraphQLName(value="CDP_Segment")
@GraphQLDescription(value="Segments are similar to lists in that profiles may be in the segment, or not. However, where profiles are explicitly added to lists, they are dynamically resolved to segments based on the filter defined in the segment.")
public class CDPSegment {
    public static final String TYPE_NAME = "CDP_Segment";
    private Segment segment;

    public CDPSegment(Segment segment) {
        this.segment = segment;
    }

    public Segment getSegment() {
        return this.segment;
    }

    @GraphQLField
    public String id() {
        return this.segment != null ? this.segment.getItemId() : null;
    }

    @GraphQLField
    public CDPView view() {
        if (this.segment == null) {
            return null;
        }
        return this.segment.getScope() != null ? new CDPView(this.segment.getScope()) : null;
    }

    @GraphQLField
    public String name() {
        if (this.segment != null && this.segment.getMetadata() != null) {
            return this.segment.getMetadata().getName();
        }
        return null;
    }

    @GraphQLField
    public Object filter(DataFetchingEnvironment environment) {
        return new SegmentConditionParser(this.segment.getCondition(), environment).parse();
    }
}

