/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.output;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLID;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.api.Topic;
import org.apache.unomi.graphql.types.output.CDPView;

@GraphQLName(value="CDP_Topic")
@GraphQLDescription(value="Topics represent the core entities of the business that is using the Customer Data Platform. The Customer Data Platform aims to find correlation between profiles and the topics. When such correlations are identified, it is called Interests.")
public class CDPTopic {
    public static final String TYPE_NAME = "CDP_Topic";
    private final Topic topic;

    public CDPTopic() {
        this(null);
    }

    public CDPTopic(Topic topic) {
        this.topic = topic;
    }

    @GraphQLField
    public @GraphQLID @GraphQLNonNull String id(DataFetchingEnvironment environment) {
        return this.topic != null ? this.topic.getTopicId() : null;
    }

    @GraphQLField
    @GraphQLNonNull
    public String name(DataFetchingEnvironment environment) {
        return this.topic != null ? this.topic.getName() : null;
    }

    @GraphQLField
    @GraphQLNonNull
    public CDPView view(DataFetchingEnvironment environment) {
        return this.topic != null ? new CDPView(this.topic.getScope()) : null;
    }
}

