/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.types.resolvers;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import org.apache.unomi.graphql.converters.UnomiToGraphQLConverter;
import org.apache.unomi.graphql.schema.GraphQLSchemaProvider;
import org.apache.unomi.graphql.schema.json.JSONSchema;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.types.resolvers.BaseTypeResolver;
import org.apache.unomi.schema.api.JsonSchemaWrapper;
import org.apache.unomi.schema.api.SchemaService;

public class CDPEventInterfaceResolver
extends BaseTypeResolver {
    @Override
    public GraphQLObjectType getType(TypeResolutionEnvironment env) {
        CDPEventInterface eventInterface;
        ServiceManager serviceManager = (ServiceManager)env.getContext();
        SchemaService schemaService = serviceManager.getService(SchemaService.class);
        JsonSchemaWrapper eventSchema = schemaService.getSchema("https://unomi.apache.org/schemas/json/events/" + (eventInterface = (CDPEventInterface)env.getObject()).getEvent().getEventType() + "/1-0-0");
        if (eventSchema != null) {
            JSONSchema jsonSchema = GraphQLSchemaProvider.buildJSONSchema(eventSchema, schemaService);
            String typeName = UnomiToGraphQLConverter.convertEventType(jsonSchema.getName());
            return env.getSchema().getObjectType(typeName);
        }
        return super.getType(env);
    }
}

