/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.utils;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;

public class ConditionBuilder {
    private final ConditionType conditionType;
    private String propertyName;
    private String comparisonOperator;
    private String propertyValue;
    private List<String> propertyValues;
    private OffsetDateTime propertyValueDate;
    private Object propertyValueInteger;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    private ConditionBuilder(ConditionType conditionType) {
        this.conditionType = conditionType;
    }

    public static ConditionBuilder create(ConditionType conditionType) {
        return new ConditionBuilder(conditionType);
    }

    public ConditionBuilder property(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public ConditionBuilder operator(String comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
        return this;
    }

    public ConditionBuilder value(String propertyValue) {
        this.propertyValue = propertyValue;
        return this;
    }

    public ConditionBuilder value(OffsetDateTime propertyValueDate) {
        this.propertyValueDate = propertyValueDate;
        return this;
    }

    public ConditionBuilder value(Object propertyValueInteger) {
        this.propertyValueInteger = propertyValueInteger;
        return this;
    }

    public ConditionBuilder values(List<String> propertyValues) {
        this.propertyValues = propertyValues;
        return this;
    }

    public ConditionBuilder parameter(String parameter, Object value) {
        this.parameters.put(parameter, value);
        return this;
    }

    public ConditionBuilder eq(String value) {
        return this.value(value).operator("equals");
    }

    public ConditionBuilder neq(String value) {
        return this.value(value).operator("notEquals");
    }

    public ConditionBuilder lt(String value) {
        return this.value(value).operator("lessThan");
    }

    public ConditionBuilder lte(String value) {
        return this.value(value).operator("lessThanOrEqualTo");
    }

    public ConditionBuilder gt(String value) {
        return this.value(value).operator("greaterThan");
    }

    public ConditionBuilder gte(String value) {
        return this.value(value).operator("greaterThanOrEqualTo");
    }

    public Condition build() {
        Condition condition = new Condition(this.conditionType);
        if (StringUtils.isNotEmpty((CharSequence)this.propertyName)) {
            condition.setParameter("propertyName", (Object)this.propertyName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.comparisonOperator)) {
            condition.setParameter("comparisonOperator", (Object)this.comparisonOperator);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.propertyValue)) {
            condition.setParameter("propertyValue", (Object)this.propertyValue);
        }
        if (this.propertyValueDate != null) {
            condition.setParameter("propertyValueDate", (Object)this.propertyValueDate);
        }
        if (this.propertyValueInteger != null) {
            condition.setParameter("propertyValueInteger", this.propertyValueInteger);
        }
        if (this.propertyValues != null && !this.propertyValues.isEmpty()) {
            condition.setParameter("propertyValues", this.propertyValues);
        }
        if (!this.parameters.isEmpty()) {
            this.parameters.forEach((arg_0, arg_1) -> ((Condition)condition).setParameter(arg_0, arg_1));
        }
        return condition;
    }
}

