/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.utils;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Map;

public final class DateUtils {
    private DateUtils() {
        throw new AssertionError();
    }

    public static OffsetDateTime toOffsetDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date toDate(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return null;
        }
        return new Date(offsetDateTime.toInstant().toEpochMilli());
    }

    public static OffsetDateTime offsetDateTimeFromMap(Map<String, Object> parameterValues) {
        if (parameterValues == null) {
            return null;
        }
        Map offsetAsMap = (Map)parameterValues.get("offset");
        ZoneOffset zoneOffset = ZoneOffset.of(offsetAsMap.get("id").toString());
        return OffsetDateTime.of((Integer)parameterValues.get("year"), (Integer)parameterValues.get("monthValue"), (Integer)parameterValues.get("dayOfMonth"), (Integer)parameterValues.get("hour"), (Integer)parameterValues.get("minute"), (Integer)parameterValues.get("second"), (Integer)parameterValues.get("nano"), zoneOffset);
    }
}

