/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;

public class EventBuilder {
    private final Profile profile;
    private final String eventType;
    private Map<String, Object> propertiesToAdd;
    private Map<String, Object> propertiesToUpdate;
    private List<String> propertiesToDelete;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean persistent;

    public EventBuilder(String eventType, Profile profile) {
        this.eventType = eventType;
        this.profile = profile;
    }

    public static EventBuilder create(String eventType, Profile profile) {
        return new EventBuilder(eventType, profile);
    }

    public EventBuilder setPropertiesToAdd(Map<String, Object> propertiesToAdd) {
        this.propertiesToAdd = propertiesToAdd;
        return this;
    }

    public EventBuilder setPropertiesToUpdate(Map<String, Object> propertiesToUpdate) {
        this.propertiesToUpdate = propertiesToUpdate;
        return this;
    }

    public EventBuilder setPropertiesToDelete(List<String> propertiesToDelete) {
        this.propertiesToDelete = propertiesToDelete;
        return this;
    }

    public EventBuilder setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public EventBuilder setProperty(String property, Object value) {
        this.properties.put(property, value);
        return this;
    }

    public Event build() {
        Event event = new Event(this.eventType, null, this.profile, null, null, null, new Date());
        event.setPersistent(this.persistent);
        event.setProperty("targetId", (Object)this.profile.getItemId());
        event.setProperty("targetType", (Object)"profile");
        if (this.propertiesToAdd != null) {
            event.setProperty("add", this.propertiesToAdd);
        }
        if (this.propertiesToUpdate != null) {
            event.setProperty("update", this.propertiesToUpdate);
        }
        if (this.propertiesToDelete != null) {
            event.setProperty("delete", this.propertiesToDelete);
        }
        if (!this.properties.isEmpty()) {
            event.setProperties(this.properties);
        }
        return event;
    }
}

