/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.utils;

import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.processor.util.NamingKit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.unomi.graphql.utils.StringUtils;

public class ReflectionUtil {
    private static final String UNOMI_TYPE_FIELD = "UNOMI_TYPE";

    public static String getStaticField(Class clazz, String field) {
        try {
            return (String)clazz.getField(field).get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Class %s doesn't have a publicly accessible \"TYPE_NAME\" field", clazz.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error resolving \"TYPE_NAME\" for class %s", clazz.getName()), e);
        }
    }

    public static String getUnomiType(Class clazz) {
        return ReflectionUtil.getStaticField(clazz, UNOMI_TYPE_FIELD);
    }

    public static String resolveTypeName(Class<?> annotatedClass) {
        GraphQLName graphQLName = annotatedClass.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName((String)(graphQLName != null ? graphQLName.value() : annotatedClass.getSimpleName()));
    }

    public static String resolveFieldName(Field annotatedField) {
        GraphQLName graphQLName = annotatedField.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName((String)(graphQLName != null ? graphQLName.value() : annotatedField.getName()));
    }

    public static List<String> getNonDynamicFields(Class<?> annotatedClass) {
        Field[] declaredFields = annotatedClass.getDeclaredFields();
        ArrayList<String> result = new ArrayList<String>();
        for (Field field : declaredFields) {
            result.add(ReflectionUtil.resolveFieldName(field));
        }
        return result;
    }

    public static Method findMethod(String methodName, Class clazz) {
        String getterName = null;
        if (!methodName.startsWith("get")) {
            getterName = "get" + StringUtils.capitalize(methodName);
        }
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) && !method.getName().equals(getterName)) continue;
            return method;
        }
        return null;
    }

    public static Field findField(String fieldName, Class clazz) {
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }
}

