/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.jupyter.JupyterInterpreter;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.ResourcePool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class IPythonKernelTest {
    protected InterpreterGroup intpGroup;
    protected Interpreter interpreter;
    private ResourcePool resourcePool;

    IPythonKernelTest() {
    }

    @BeforeEach
    public void setUp() throws InterpreterException {
        Properties properties = new Properties();
        this.interpreter = new LazyOpenInterpreter((Interpreter)new JupyterInterpreter(properties));
        this.intpGroup = new InterpreterGroup();
        this.resourcePool = new LocalResourcePool("local");
        this.intpGroup.setResourcePool(this.resourcePool);
        this.intpGroup.put("session_1", new ArrayList());
        this.intpGroup.get("session_1").add(this.interpreter);
        this.interpreter.setInterpreterGroup(this.intpGroup);
        this.interpreter.open();
    }

    @AfterEach
    public void tearDown() throws InterpreterException {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
    }

    @Test
    void testPythonBasics() throws InterpreterException, InterruptedException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("import sys\nprint(sys.version[0])", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Thread.sleep(100L);
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("'hello world'", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"'hello world'", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().trim());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print(u'\u4f60\u597d')", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"\u4f60\u597d\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("'hello world'\n'hello world2'", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"'hello world2'", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().trim());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('hello world')", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"hello world\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('hello world')\nprint('hello world2')", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"hello world\nhello world2\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("abc=1", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)0, (int)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("if abc > 0:\n\tprint('True')\nelse:\n\tprint('False')", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"True\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("for i in range(3):\n\tprint(i)", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"0\n1\n2\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print(unknown)", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("name 'unknown' is not defined"));
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("1/0", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("ZeroDivisionError"));
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("from __future__ import print_function\ndef greet(name):\n    print('Hello', name)\ngreet('Jack')", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"Hello Jack\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('there is no Error: ok')", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"there is no Error: ok\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("# print('Hello')", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)0, (int)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("# print('Hello')\n# print('How are u?')\n# time.sleep(1)", context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)0, (int)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("for i in range(1,4):\n\tprint(i)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"1\n2\n3\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
    }

    @Test
    void testInterpolate() throws InterpreterException, IOException {
        this.intpGroup.getResourcePool().put("name", (Object)"hello");
        InterpreterContext context = this.getInterpreterContext();
        context.getLocalProperties().put("interpolate", "true");
        String st = "print('{name}')";
        InterpreterResult result = this.interpreter.interpret(st, context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertEquals((Object)"hello\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
    }

    @Test
    void testCodeCompletion() throws InterpreterException, InterruptedException {
        InterpreterContext context = this.getInterpreterContext();
        String st = "a='hello'";
        InterpreterResult result = this.interpreter.interpret(st, context);
        Thread.sleep(100L);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        st = "a.";
        List completions = this.interpreter.completion(st, st.length(), context);
        Assertions.assertTrue((completions.size() > 20 ? 1 : 0) != 0);
        context = this.getInterpreterContext();
        st = "a.co";
        completions = this.interpreter.completion(st, st.length(), context);
        Assertions.assertEquals((int)1, (int)completions.size());
        Assertions.assertEquals((Object)"count", (Object)((InterpreterCompletion)completions.get(0)).getValue());
        context = this.getInterpreterContext();
        st = "a.co\b='hello";
        completions = this.interpreter.completion(st, 4, context);
        Assertions.assertEquals((int)1, (int)completions.size());
        Assertions.assertEquals((Object)"count", (Object)((InterpreterCompletion)completions.get(0)).getValue());
    }

    @Test
    void testUpdateOutput() throws IOException, InterpreterException {
        InterpreterContext context = this.getInterpreterContext();
        String st = "import sys\nimport time\nfrom IPython.display import display, clear_output\nfor i in range(10):\n    time.sleep(0.25)\n    clear_output(wait=True)\n    print(i)\n    sys.stdout.flush()";
        InterpreterResult result = this.interpreter.interpret(st, context);
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assertions.assertEquals((Object)"9\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
    }

    protected InterpreterContext getInterpreterContext() {
        HashMap<String, String> localProperties = new HashMap<String, String>();
        localProperties.put("kernel", "python");
        return InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").setInterpreterOut(new InterpreterOutput()).setIntpEventClient((RemoteInterpreterEventClient)Mockito.mock(RemoteInterpreterEventClient.class)).setLocalProperties(localProperties).setResourcePool(this.resourcePool).build();
    }
}

