/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.jupyter.JupyterInterpreter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IRKernelTest {
    protected Interpreter interpreter;
    protected static boolean ENABLE_GOOGLEVIS_TEST = true;

    protected Interpreter createInterpreter(Properties properties) {
        return new JupyterInterpreter(properties);
    }

    @BeforeEach
    public void setUp() throws InterpreterException {
        Properties properties = new Properties();
        InterpreterContext context = this.getInterpreterContext();
        InterpreterContext.set((InterpreterContext)context);
        this.interpreter = this.createInterpreter(properties);
        InterpreterGroup interpreterGroup = new InterpreterGroup();
        interpreterGroup.addInterpreterToSession((Interpreter)new LazyOpenInterpreter(this.interpreter), "session_1");
        this.interpreter.setInterpreterGroup(interpreterGroup);
        this.interpreter.open();
    }

    @AfterEach
    public void tearDown() throws InterpreterException {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
    }

    @Test
    void testIRInterpreter() throws InterpreterException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("1+1", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List resultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType(), (String)resultMessages.toString());
        Assertions.assertEquals((Object)"2", (Object)((InterpreterResultMessage)resultMessages.get(0)).getData(), (String)resultMessages.toString());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("unknown_var", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        resultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size());
        Assertions.assertEquals((Object)InterpreterResult.Type.TEXT, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType(), (String)result.toString());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)resultMessages.get(0)).getData().contains("unknown_var"), (String)resultMessages.toString());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("foo <- TRUE\nprint(foo)\nbare <- c(1, 2.5, 4)\nprint(bare)\ndouble <- 15.0\nprint(double)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        resultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size());
        Assertions.assertEquals((Object)InterpreterResult.Type.TEXT, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType(), (String)result.toString());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)resultMessages.get(0)).getData().contains("[1] TRUE\n[1] 1.0 2.5 4.0\n[1] 15\n"), (String)resultMessages.toString());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("hist(mtcars$mpg)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        resultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size());
        Assertions.assertEquals((Object)InterpreterResult.Type.IMG, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType(), (String)resultMessages.toString());
        result = this.interpreter.interpret("library(ggplot2)\nggplot(diamonds, aes(x=carat, y=price, color=cut)) + geom_point()", this.getInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        resultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)resultMessages.size());
        Assertions.assertEquals((Object)InterpreterResult.Type.IMG, (Object)((InterpreterResultMessage)resultMessages.get(0)).getType(), (String)resultMessages.toString());
        if (ENABLE_GOOGLEVIS_TEST) {
            context = this.getInterpreterContext();
            result = this.interpreter.interpret("library(googleVis)\ndf=data.frame(country=c(\"US\", \"GB\", \"BR\"), \n              val1=c(10,13,14), \n              val2=c(23,12,32))\nBar <- gvisBarChart(df)\nprint(Bar, tag = 'chart')", context);
            Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
            resultMessages = context.out.toInterpreterResultMessage();
            Assertions.assertEquals((int)2, (int)resultMessages.size());
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)resultMessages.get(1)).getType(), (String)resultMessages.toString());
            Assertions.assertTrue((boolean)((InterpreterResultMessage)resultMessages.get(1)).getData().contains("javascript"), (String)((InterpreterResultMessage)resultMessages.get(1)).getData());
        }
    }

    protected InterpreterContext getInterpreterContext() {
        HashMap<String, String> localProperties = new HashMap<String, String>();
        localProperties.put("kernel", "ir");
        InterpreterContext context = InterpreterContext.builder().setNoteId("note_1").setParagraphId("paragraph_1").setInterpreterOut(new InterpreterOutput()).setLocalProperties(localProperties).build();
        return context;
    }
}

