/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.yubico.core.RegistrationStorage;
import com.yubico.data.CredentialRegistration;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRegistrationStorage
implements RegistrationStorage,
CredentialRepository {
    private static final Logger log = LoggerFactory.getLogger(InMemoryRegistrationStorage.class);
    private final Cache<String, Set<CredentialRegistration>> storage = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterAccess(1L, TimeUnit.DAYS).build();

    @Override
    public boolean addRegistrationByUsername(String username, CredentialRegistration reg) {
        try {
            return ((Set)this.storage.get((Object)username.toLowerCase(), HashSet::new)).add(reg);
        }
        catch (ExecutionException e) {
            log.error("Failed to add registration", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Set<PublicKeyCredentialDescriptor> getCredentialIdsForUsername(String username) {
        return this.getRegistrationsByUsername(username.toLowerCase()).stream().map(registration -> PublicKeyCredentialDescriptor.builder().id(registration.getCredential().getCredentialId()).build()).collect(Collectors.toSet());
    }

    @Override
    public Collection<CredentialRegistration> getRegistrationsByUsername(String username) {
        try {
            return (Collection)this.storage.get((Object)username.toLowerCase(), HashSet::new);
        }
        catch (ExecutionException e) {
            log.error("Registration lookup failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<CredentialRegistration> getRegistrationsByUserHandle(ByteArray userHandle) {
        return this.storage.asMap().values().stream().flatMap(Collection::stream).filter(credentialRegistration -> userHandle.equals((Object)credentialRegistration.getUserIdentity().getId())).collect(Collectors.toList());
    }

    public Optional<String> getUsernameForUserHandle(ByteArray userHandle) {
        return this.getRegistrationsByUserHandle(userHandle).stream().findAny().map(CredentialRegistration::getUsername);
    }

    public Optional<ByteArray> getUserHandleForUsername(String username) {
        return this.getRegistrationsByUsername(username.toLowerCase()).stream().findAny().map(reg -> reg.getUserIdentity().getId());
    }

    @Override
    public void updateSignatureCount(AssertionResult result) {
        CredentialRegistration registration = this.getRegistrationByUsernameAndCredentialId(result.getUsername().toLowerCase(Locale.ROOT), result.getCredentialId()).orElseThrow(() -> new NoSuchElementException(String.format("Credential \"%s\" is not registered to user \"%s\"", result.getCredentialId(), result.getUsername())));
        Set regs = (Set)this.storage.getIfPresent((Object)result.getUsername().toLowerCase());
        Objects.requireNonNull(regs).remove(registration);
        regs.add(registration.withSignatureCount(result.getSignatureCount()));
    }

    @Override
    public Optional<CredentialRegistration> getRegistrationByUsernameAndCredentialId(String username, ByteArray id) {
        try {
            return ((Set)this.storage.get((Object)username.toLowerCase(), HashSet::new)).stream().filter(credReg -> id.equals((Object)credReg.getCredential().getCredentialId())).findFirst();
        }
        catch (ExecutionException e) {
            log.error("Registration lookup failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removeRegistrationByUsername(String username, CredentialRegistration credentialRegistration) {
        try {
            return ((Set)this.storage.get((Object)username.toLowerCase(), HashSet::new)).remove(credentialRegistration);
        }
        catch (ExecutionException e) {
            log.error("Failed to remove registration", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removeAllRegistrations(String username) {
        this.storage.invalidate((Object)username.toLowerCase());
        return true;
    }

    public Optional<RegisteredCredential> lookup(ByteArray credentialId, ByteArray userHandle) {
        Optional<CredentialRegistration> registrationMaybe = this.storage.asMap().values().stream().flatMap(Collection::stream).filter(credReg -> credentialId.equals((Object)credReg.getCredential().getCredentialId())).findAny();
        log.debug("lookup credential ID: {}, user handle: {}; result: {}", new Object[]{credentialId, userHandle, registrationMaybe});
        return registrationMaybe.flatMap(registration -> Optional.of(RegisteredCredential.builder().credentialId(registration.getCredential().getCredentialId()).userHandle(registration.getUserIdentity().getId()).publicKeyCose(registration.getCredential().getPublicKeyCose()).signatureCount(registration.getSignatureCount()).build()));
    }

    public Set<RegisteredCredential> lookupAll(ByteArray credentialId) {
        return CollectionUtil.immutableSet(this.storage.asMap().values().stream().flatMap(Collection::stream).filter(reg -> reg.getCredential().getCredentialId().equals((Object)credentialId)).map(reg -> RegisteredCredential.builder().credentialId(reg.getCredential().getCredentialId()).userHandle(reg.getUserIdentity().getId()).publicKeyCose(reg.getCredential().getPublicKeyCose()).signatureCount(reg.getSignatureCount()).build()).collect(Collectors.toSet()));
    }

    public Cache<String, Set<CredentialRegistration>> getStorage() {
        return this.storage;
    }
}

