/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation.resolver;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.yubico.webauthn.attestation.TrustResolver;
import com.yubico.webauthn.attestation.resolver.SimpleTrustResolver;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class SimpleTrustResolverWithEquality
implements TrustResolver {
    private final SimpleTrustResolver subresolver;
    private final Multimap<String, X509Certificate> trustedCerts = ArrayListMultimap.create();

    public SimpleTrustResolverWithEquality(Collection<X509Certificate> trustedCertificates) {
        this.subresolver = new SimpleTrustResolver(trustedCertificates);
        for (X509Certificate cert : trustedCertificates) {
            this.trustedCerts.put((Object)cert.getSubjectDN().getName(), (Object)cert);
        }
    }

    public Optional<X509Certificate> resolveTrustAnchor(X509Certificate attestationCertificate, List<X509Certificate> caCertificateChain) {
        Optional subResult = this.subresolver.resolveTrustAnchor(attestationCertificate, caCertificateChain);
        if (subResult.isPresent()) {
            return subResult;
        }
        for (X509Certificate cert : this.trustedCerts.get((Object)attestationCertificate.getSubjectDN().getName())) {
            if (!cert.equals(attestationCertificate)) continue;
            return Optional.of(cert);
        }
        return Optional.empty();
    }
}

