/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mgmt.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authorization.LdapUserAttributesToRolesAuthorizationGenerator;
import org.apereo.cas.authorization.LdapUserGroupsToRolesAuthorizationGenerator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasManagementConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthorizationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.SearchOperation;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casManagementLdapAuthorizationConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class, CasManagementConfigurationProperties.class})
public class CasManagementLdapAuthorizationConfiguration {
    private static SearchOperation ldapAuthorizationGeneratorUserSearchExecutor(CasManagementConfigurationProperties managementProperties) {
        LdapAuthorizationProperties ldapAuthz = managementProperties.getLdap().getLdapAuthz();
        return LdapUtils.newLdaptiveSearchOperation((String)ldapAuthz.getBaseDn(), (String)ldapAuthz.getSearchFilter(), new ArrayList(0), (List)CollectionUtils.wrap((Object)ldapAuthz.getRoleAttribute()));
    }

    private static SearchOperation ldapAuthorizationGeneratorGroupSearchExecutor(CasManagementConfigurationProperties managementProperties) {
        LdapAuthorizationProperties ldapAuthz = managementProperties.getLdap().getLdapAuthz();
        return LdapUtils.newLdaptiveSearchOperation((String)ldapAuthz.getGroupBaseDn(), (String)ldapAuthz.getGroupFilter(), new ArrayList(0), (List)CollectionUtils.wrap((Object)ldapAuthz.getGroupAttribute()));
    }

    @Bean
    public AuthorizationGenerator authorizationGenerator(CasManagementConfigurationProperties managementProperties) {
        LdapAuthorizationProperties ldapAuthz = managementProperties.getLdap().getLdapAuthz();
        if (StringUtils.isNotBlank((CharSequence)ldapAuthz.getGroupFilter()) && StringUtils.isNotBlank((CharSequence)ldapAuthz.getGroupAttribute())) {
            return new LdapUserGroupsToRolesAuthorizationGenerator(CasManagementLdapAuthorizationConfiguration.ldapAuthorizationGeneratorUserSearchExecutor(managementProperties), ldapAuthz.isAllowMultipleResults(), ldapAuthz.getGroupAttribute(), ldapAuthz.getGroupPrefix(), CasManagementLdapAuthorizationConfiguration.ldapAuthorizationGeneratorGroupSearchExecutor(managementProperties));
        }
        return new LdapUserAttributesToRolesAuthorizationGenerator(CasManagementLdapAuthorizationConfiguration.ldapAuthorizationGeneratorUserSearchExecutor(managementProperties), ldapAuthz.isAllowMultipleResults(), ldapAuthz.getRoleAttribute(), ldapAuthz.getRolePrefix());
    }
}

