/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mgmt;

import com.google.common.base.Splitter;
import com.mchange.io.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasManagementConfigurationProperties;
import org.apereo.cas.configuration.model.SubmissionNotifications;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.mgmt.BranchMap;
import org.apereo.cas.mgmt.GitUtil;
import org.apereo.cas.mgmt.MgmtManagerFactory;
import org.apereo.cas.mgmt.authentication.CasUserProfile;
import org.apereo.cas.mgmt.controller.AbstractVersionControlController;
import org.apereo.cas.mgmt.domain.PendingItem;
import org.apereo.cas.mgmt.domain.RegisteredServiceItem;
import org.apereo.cas.mgmt.domain.RejectData;
import org.apereo.cas.mgmt.factory.RepositoryFactory;
import org.apereo.cas.mgmt.util.CasManagementUtils;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.ResourceUtils;
import org.eclipse.jgit.diff.RawText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="casManagementSubmissisonsController")
@RequestMapping(path={"api/submissions"}, produces={"application/json"})
public class SubmissionController
extends AbstractVersionControlController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SubmissionController.class);
    private static final int MAX_EMAIL_LENGTH = 200;
    private final RepositoryFactory repositoryFactory;
    private final MgmtManagerFactory<? extends ServicesManager> managerFactory;
    private final CasManagementConfigurationProperties managementProperties;
    private final CasConfigurationProperties casProperties;
    private final CommunicationsManager communicationsManager;

    public SubmissionController(RepositoryFactory repositoryFactory, MgmtManagerFactory<? extends ServicesManager> managerFactory, CasManagementConfigurationProperties managementProperties, CasConfigurationProperties casProperties, CommunicationsManager communicationsManager) {
        this.repositoryFactory = repositoryFactory;
        this.managerFactory = managerFactory;
        this.managementProperties = managementProperties;
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
    }

    @GetMapping
    public List<RegisteredServiceItem> getSubmissions(Authentication authentication) throws Exception {
        List<RegisteredServiceItem> list;
        block8: {
            this.isAdministrator(authentication);
            LOGGER.debug(this.managementProperties.getSubmissions().getSubmitDir());
            Stream<Path> stream = Files.list(Paths.get(this.managementProperties.getSubmissions().getSubmitDir(), new String[0]));
            try {
                list = stream.map(SubmissionController::createServiceItem).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            stream.close();
        }
        return list;
    }

    @GetMapping(value={"/pending"})
    public List<PendingItem> getPendingSubmissions(Authentication authentication) throws Exception {
        List<PendingItem> list;
        block8: {
            CasUserProfile casUserProfile = CasUserProfile.from((Authentication)authentication);
            Stream<Path> stream = Files.list(Paths.get(this.managementProperties.getSubmissions().getSubmitDir(), new String[0]));
            try {
                List<PendingItem> list2 = stream.filter(p -> SubmissionController.isSubmitter(p, casUserProfile)).map(SubmissionController::createPendingItem).collect(Collectors.toList());
                GitUtil git = this.repositoryFactory.masterRepository();
                List bulks = git.branches().map(arg_0 -> ((GitUtil)git).mapBranches(arg_0)).filter(b -> !b.getName().endsWith("master") && b.getCommitter().equalsIgnoreCase(casUserProfile.getId())).filter(r -> !r.isAccepted() && !r.isRejected()).map(p -> SubmissionController.createPendingItem(p, git)).collect(Collectors.toList());
                list2.addAll(bulks);
                list = list2;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            stream.close();
        }
        return list;
    }

    private static boolean isSubmitter(Path p, CasUserProfile casUserProfile) {
        return SubmissionController.getSubmitter(p)[0].equals(casUserProfile.getEmail());
    }

    private static RegisteredServiceItem createServiceItem(Path p) {
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer();
        RegisteredService service = (RegisteredService)serializer.from(p.toFile());
        RegisteredServiceItem serviceItem = new RegisteredServiceItem();
        serviceItem.setAssignedId(p.getFileName().toString());
        serviceItem.setEvalOrder(service.getEvaluationOrder());
        serviceItem.setName(service.getName());
        serviceItem.setServiceId(service.getServiceId());
        serviceItem.setDescription(DigestUtils.abbreviate((String)service.getDescription()));
        serviceItem.setSubmitter(SubmissionController.getSubmitter(p)[1]);
        serviceItem.setSubmitted(SubmissionController.getSubmitted(p));
        serviceItem.setStatus(SubmissionController.status(p.getFileName().toString()));
        serviceItem.setStaged(service.getEnvironments().contains("staged"));
        serviceItem.setType(CasManagementUtils.getType((RegisteredService)service));
        return serviceItem;
    }

    private static PendingItem createPendingItem(Path p) {
        RegisteredService service = CasManagementUtils.fromJson((File)p.toFile());
        PendingItem serviceItem = new PendingItem();
        serviceItem.setId(p.getFileName().toString());
        serviceItem.setName(service.getName());
        serviceItem.setServiceId(service.getServiceId());
        serviceItem.setSubmitted(SubmissionController.getSubmitted(p));
        serviceItem.setStatus(SubmissionController.status(p.getFileName().toString()));
        serviceItem.setType(CasManagementUtils.getType((RegisteredService)service));
        return serviceItem;
    }

    private static PendingItem createPendingItem(BranchMap p, GitUtil git) {
        try {
            PendingItem serviceItem = new PendingItem();
            serviceItem.setId(p.getId());
            serviceItem.setName(p.getFullMessage());
            serviceItem.setServiceId(git.getDiffsToRevert(p.getName()).size() + " services");
            serviceItem.setSubmitted(CasManagementUtils.formatDateTime((long)p.getCommitTime()));
            serviceItem.setStatus("EDIT");
            return serviceItem;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String status(String path) {
        if (path.startsWith("edit")) {
            return "EDIT";
        }
        if (path.startsWith("remove")) {
            return "REMOVE";
        }
        return "SUBMITTED";
    }

    @PostMapping(value={"/yaml"})
    public String getYamlSubmission(Authentication authentication, @RequestBody String id) throws Exception {
        this.isAdministrator(authentication);
        RegisteredService svc = CasManagementUtils.fromJson((File)new File(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id));
        return CasManagementUtils.toYaml((RegisteredService)svc);
    }

    @PostMapping(value={"/json"})
    public String getJsonSubmission(Authentication authentication, @RequestBody String id) throws Exception {
        this.isAdministrator(authentication);
        RegisteredService svc = CasManagementUtils.fromJson((File)new File(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id));
        return CasManagementUtils.toJson((RegisteredService)svc);
    }

    @PostMapping(value={"/metadata"})
    public String getMetadataSubmission(Authentication authentication, @RequestBody String id) throws Exception {
        this.isAdministrator(authentication);
        SamlRegisteredService svc = (SamlRegisteredService)CasManagementUtils.fromJson((File)new File(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id));
        String location = svc.getMetadataLocation();
        if (location.contains("mdq.incommon.org")) {
            HttpResponse resp = this.fetchMetadata(svc.getMetadataLocation().replace("{0}", EncodingUtils.urlEncode((String)svc.getServiceId())));
            HttpEntity entity = resp.getEntity();
            return IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
        }
        String fileName = DigestUtils.sha((String)svc.getServiceId()) + ".xml";
        File res = ResourceUtils.getResourceFrom((String)("file:/" + this.managementProperties.getMetadataRepoDir() + "/" + fileName)).getFile();
        return FileUtils.getContentsAsString((File)res);
    }

    private EmailProperties copyEmail(EmailProperties source) {
        EmailProperties emailProps = new EmailProperties();
        emailProps.setSubject(source.getSubject());
        emailProps.setAttributeName(source.getAttributeName());
        emailProps.setBcc(source.getBcc());
        emailProps.setCc(source.getCc());
        emailProps.setFrom(source.getFrom());
        emailProps.setReplyTo(source.getReplyTo());
        emailProps.setText(source.getText());
        emailProps.setValidateAddresses(source.isValidateAddresses());
        emailProps.setHtml(source.isHtml());
        return emailProps;
    }

    @PostMapping(path={"/reject"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void rejectSubmission(Authentication authentication, @RequestBody RejectData data) throws Exception {
        this.isAdministrator(authentication);
        Path path = Paths.get(this.managementProperties.getSubmissions().getSubmitDir() + "/" + data.getId(), new String[0]);
        RegisteredService service = CasManagementUtils.fromJson((File)path.toFile());
        String contact = SubmissionController.getSubmitter(path)[0];
        Files.delete(path);
        this.sendRejectMessage(service.getName(), data.getNote(), contact, data.getId().contains("edit"));
    }

    private void sendRejectMessage(String submitName, String note, String email, boolean isChange) {
        if (this.communicationsManager.isMailSenderDefined()) {
            SubmissionNotifications notifications = this.managementProperties.getSubmissions().getNotifications();
            EmailProperties emailProps = isChange ? this.copyEmail(notifications.getRejectChange()) : this.copyEmail(notifications.getReject());
            emailProps.setSubject(MessageFormat.format(emailProps.getSubject(), submitName));
            this.communicationsManager.email(emailProps, email, MessageFormat.format(emailProps.getText(), submitName, note));
        }
    }

    @PostMapping(value={"added"})
    @ResponseStatus(value=HttpStatus.OK)
    public void addedSubmission(Authentication authentication, @RequestBody String id) throws Exception {
        this.isAdministrator(authentication);
        Path path = Paths.get(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id, new String[0]);
        RegisteredService service = CasManagementUtils.fromJson((File)path.toFile());
        String contact = SubmissionController.getSubmitter(path)[0];
        Files.delete(path);
        this.sendAddedMessage(service.getName(), "", contact);
    }

    private void sendAddedMessage(String submitName, String note, String email) {
        if (this.communicationsManager.isMailSenderDefined()) {
            EmailProperties emailProps = this.copyEmail(this.managementProperties.getSubmissions().getNotifications().getAdded());
            emailProps.setSubject(MessageFormat.format(emailProps.getSubject(), submitName));
            this.communicationsManager.email(emailProps, email, MessageFormat.format(emailProps.getText(), submitName, note));
        }
    }

    @PostMapping(value={"diff"})
    @ResponseStatus(value=HttpStatus.OK)
    public void diffSubmission(Authentication authentication, HttpServletResponse response, @RequestBody String id) throws Exception {
        this.isAdministrator(authentication);
        GitUtil git = this.repositoryFactory.masterRepository();
        RawText subPath = new RawText(org.apache.commons.io.FileUtils.readFileToByteArray((File)new File(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id)));
        List splitSub = Splitter.on((String)"-").splitToList((CharSequence)id);
        RawText gitPath = new RawText(org.apache.commons.io.FileUtils.readFileToByteArray((File)new File(this.managementProperties.getVersionControl().getServicesRepo() + "/service-" + (String)splitSub.get(1))));
        response.getOutputStream().write(git.getFormatter(gitPath, subPath));
    }

    @PostMapping(value={"accept"})
    @ResponseStatus(value=HttpStatus.OK)
    public void acceptSubmission(Authentication authentication, @RequestBody String id) throws Exception {
        this.isAdministrator(authentication);
        ServicesManager manager = this.managerFactory.from(authentication);
        Path path = Paths.get(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id, new String[0]);
        RegisteredService service = CasManagementUtils.fromJson((File)path.toFile());
        manager.save(service);
        String contact = SubmissionController.getSubmitter(path)[0];
        Files.delete(path);
        this.sendAcceptMessage(service.getName(), contact);
    }

    private void sendAcceptMessage(String submitName, String email) {
        if (this.communicationsManager.isMailSenderDefined()) {
            EmailProperties emailProps = this.copyEmail(this.managementProperties.getSubmissions().getNotifications().getAccept());
            emailProps.setSubject(MessageFormat.format(emailProps.getSubject(), submitName));
            this.communicationsManager.email(emailProps, email, MessageFormat.format(emailProps.getText(), submitName));
        }
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteSubmission(Authentication authentication, @RequestParam String id) throws Exception {
        this.isAdministrator(authentication);
        ServicesManager manager = this.managerFactory.from(authentication);
        Path path = Paths.get(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id, new String[0]);
        RegisteredService service = CasManagementUtils.fromJson((File)path.toFile());
        String contact = SubmissionController.getSubmitter(path)[0];
        manager.delete(service.getId());
        Files.delete(path);
        this.sendDeleteMessage(service.getName(), contact);
    }

    private void sendDeleteMessage(String submitName, String email) {
        if (this.communicationsManager.isMailSenderDefined()) {
            EmailProperties emailProps = this.copyEmail(this.managementProperties.getSubmissions().getNotifications().getDelete());
            emailProps.setSubject(MessageFormat.format(emailProps.getSubject(), submitName));
            this.communicationsManager.email(emailProps, email, MessageFormat.format(emailProps.getText(), submitName));
        }
    }

    @PostMapping(value={"import"})
    public RegisteredService importSubmission(@RequestBody String id) throws Exception {
        return CasManagementUtils.fromJson((File)new File(this.managementProperties.getSubmissions().getSubmitDir() + "/" + id));
    }

    private static String[] getSubmitter(Path path) {
        try {
            byte[] email = new byte[200];
            Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]).read("original_author", ByteBuffer.wrap(email));
            return new String(email, StandardCharsets.UTF_8).trim().split(":");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new String[]{"", ""};
        }
    }

    private static String getSubmitted(Path path) {
        try {
            return LocalDateTime.ofInstant(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant(), ZoneOffset.systemDefault()).toString();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private HttpResponse fetchMetadata(String metadataLocation) {
        SamlIdPMetadataProperties metadata = this.casProperties.getAuthn().getSamlIdp().getMetadata();
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        headers.put("Content-Type", metadata.getMdq().getSupportedContentTypes());
        headers.put("Accept", "*/*");
        LOGGER.debug("Fetching dynamic metadata via MDQ for [{}]", (Object)metadataLocation);
        HttpUtils.HttpExecutionRequest execution = HttpUtils.HttpExecutionRequest.builder().url(metadataLocation).basicAuthUsername(metadata.getMdq().getBasicAuthnUsername()).basicAuthPassword(metadata.getMdq().getBasicAuthnPassword()).parameters(new HashMap()).headers(headers).method(HttpMethod.GET).build();
        HttpResponse response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)execution);
        if (response == null) {
            LOGGER.error("Unable to fetch metadata from [{}]", (Object)metadataLocation);
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        return response;
    }
}

