/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.common.web;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="Audits")
public class ClientInfoTests {
    @Test
    void verifyClientInfoCreation() {
        try {
            ClientInfo clientInfo = new ClientInfo("1.2.3.4", "1.2.3.4", UUID.randomUUID().toString(), "Paris").setHeaders(new HashMap()).setLocale(Locale.ENGLISH).setExtraInfo(new HashMap()).include("key", (Serializable)((Object)"value"));
            ClientInfoHolder.setClientInfo((ClientInfo)clientInfo);
            ClientInfo foundInfo = ClientInfoHolder.getClientInfo();
            Assertions.assertNotNull((Object)foundInfo);
            Assertions.assertNotNull((Object)foundInfo.getClientIpAddress());
            Assertions.assertNotNull((Object)foundInfo.getServerIpAddress());
            Assertions.assertNotNull((Object)foundInfo.getExtraInfo());
            Assertions.assertNotNull((Object)foundInfo.getGeoLocation());
            Assertions.assertNotNull((Object)foundInfo.getHeaders());
            Assertions.assertNotNull((Object)foundInfo.getLocale());
            Assertions.assertNotNull((Object)foundInfo.getUserAgent());
        }
        finally {
            ClientInfoHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void verifyClientInfoFromHttp() {
        try {
            MockHttpServletRequest request = ClientInfoTests.getHttpServletRequest();
            ClientInfoHolder.setClientInfo((ClientInfo)ClientInfo.from((HttpServletRequest)request));
            ClientInfo clientInfo = ClientInfo.from((HttpServletRequest)request);
            ClientInfoHolder.setClientInfo((ClientInfo)clientInfo);
            ClientInfo foundInfo = ClientInfoHolder.getClientInfo();
            Assertions.assertNotEquals((Object)foundInfo, (Object)ClientInfo.empty());
        }
        finally {
            ClientInfoHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void verifyClientInfoWithServerHost() {
        try {
            MockHttpServletRequest request = ClientInfoTests.getHttpServletRequest();
            ClientInfoHolder.setClientInfo((ClientInfo)ClientInfo.from((HttpServletRequest)request, (String)"server-header", (String)"client-header", (boolean)true));
            ClientInfo clientInfo = ClientInfo.from((HttpServletRequest)request);
            ClientInfoHolder.setClientInfo((ClientInfo)clientInfo);
            ClientInfo foundInfo = ClientInfoHolder.getClientInfo();
            Assertions.assertNotEquals((Object)foundInfo, (Object)ClientInfo.empty());
        }
        finally {
            ClientInfoHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void verifyClientInfoWithoutServerHost() {
        try {
            MockHttpServletRequest request = ClientInfoTests.getHttpServletRequest();
            ClientInfoHolder.setClientInfo((ClientInfo)ClientInfo.from((HttpServletRequest)request, (String)"server-header", (String)"client-header", (boolean)false));
            ClientInfo clientInfo = ClientInfo.from((HttpServletRequest)request);
            ClientInfoHolder.setClientInfo((ClientInfo)clientInfo);
            ClientInfo foundInfo = ClientInfoHolder.getClientInfo();
            Assertions.assertNotEquals((Object)foundInfo, (Object)ClientInfo.empty());
        }
        finally {
            ClientInfoHolder.clear();
        }
    }

    @Nonnull
    private static MockHttpServletRequest getHttpServletRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("185.86.151.11");
        request.setLocalAddr("185.88.151.11");
        request.addHeader("user-agent", (Object)"firefox");
        request.addHeader("server-header", (Object)"1.2.3.4");
        request.addHeader("client-header", (Object)"5.6.7.8");
        return request;
    }
}

