/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.dao;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.Id;

@Entity
@Table(name="CasEvent")
public class CasEvent {
    @Id
    @javax.persistence.Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    @JsonProperty(value="id")
    private long id = -1L;
    @JsonProperty(value="type")
    @Column(nullable=false)
    private String type;
    @JsonProperty(value="principalId")
    @Column(nullable=false)
    private String principalId;
    @JsonProperty(value="creationTime")
    @Column(nullable=false)
    private String creationTime;
    @JsonProperty(value="properties")
    @ElementCollection
    @MapKeyColumn(name="name")
    @Column(name="value")
    @CollectionTable(name="events_properties", joinColumns={@JoinColumn(name="eventId")})
    private Map<String, String> properties = new HashMap<String, String>();

    public CasEvent() {
        this.id = System.currentTimeMillis();
    }

    public void putTimestamp(Long time) {
        this.put("timestamp", time.toString());
    }

    public void putEventId(String eventId) {
        this.put("eventId", eventId);
    }

    public void putClientIpAddress(String loc) {
        this.put("clientip", loc);
    }

    public void putServerIpAddress(String loc) {
        this.put("serverip", loc);
    }

    public void putAgent(String dev) {
        this.put("agent", dev);
    }

    @JsonIgnore
    public Long getTimestamp() {
        return Long.valueOf(this.get("timestamp"));
    }

    @JsonIgnore
    public String getAgent() {
        return this.get("agent");
    }

    @JsonIgnore
    public String getEventId() {
        return this.get("eventId");
    }

    @JsonIgnore
    public String getClientIpAddress() {
        return this.get("clientip");
    }

    @JsonIgnore
    public String getServerIpAddress() {
        return this.get("serverip");
    }

    public void put(String key, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    private void putGeoLatitude(String s) {
        this.put("geoLatitude", s);
    }

    private void putGeoLongitude(String s) {
        this.put("geoLongitude", s);
    }

    private void putGeoAccuracy(String s) {
        this.put("geoAccuracy", s);
    }

    private void putGeoTimestamp(String s) {
        this.put("geoTimestamp", s);
    }

    public void putGeoLocation(GeoLocationRequest location) {
        this.putGeoAccuracy(location.getAccuracy());
        this.putGeoLatitude(location.getLatitude());
        this.putGeoLongitude(location.getLongitude());
        this.putGeoTimestamp(location.getTimestamp());
    }

    @JsonIgnore
    public GeoLocationRequest getGeoLocation() {
        GeoLocationRequest request = new GeoLocationRequest();
        request.setAccuracy(this.get("geoAccuracy"));
        request.setTimestamp(this.get("geoTimestamp"));
        request.setLongitude(this.get("geoLongitude"));
        request.setLatitude(this.get("geoLatitude"));
        return request;
    }

    @Generated
    public String toString() {
        return "CasEvent(id=" + this.id + ", type=" + this.type + ", principalId=" + this.principalId + ", creationTime=" + this.creationTime + ", properties=" + this.properties + ")";
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getPrincipalId() {
        return this.principalId;
    }

    @Generated
    public String getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="type")
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="principalId")
    @Generated
    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    @JsonProperty(value="creationTime")
    @Generated
    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    @JsonProperty(value="properties")
    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Generated
    public CasEvent(long id, String type, String principalId, String creationTime, Map<String, String> properties) {
        this.id = id;
        this.type = type;
        this.principalId = principalId;
        this.creationTime = creationTime;
        this.properties = properties;
    }
}

