/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AttributeDefinitionStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(AttributeDefinitionStore.class);

    private static List<Object> determineValuesForAttributeDefinition(Map<String, List<Object>> attributes, Map.Entry<String, List<Object>> entry, AttributeDefinition definition) {
        String attributeKey = (String)StringUtils.defaultIfBlank((CharSequence)definition.getAttribute(), (CharSequence)entry.getKey());
        if (attributes.containsKey(attributeKey)) {
            return attributes.get(attributeKey);
        }
        return entry.getValue();
    }

    public AttributeDefinitionStore registerAttributeDefinition(AttributeDefinition var1);

    public AttributeDefinitionStore registerAttributeDefinition(String var1, AttributeDefinition var2);

    public Optional<AttributeDefinition> locateAttributeDefinition(String var1);

    public <T extends AttributeDefinition> Optional<T> locateAttributeDefinition(String var1, Class<T> var2);

    public <T extends AttributeDefinition> Optional<T> locateAttributeDefinition(Predicate<AttributeDefinition> var1);

    public Collection<AttributeDefinition> getAttributeDefinitions();

    public Optional<Pair<AttributeDefinition, List<Object>>> resolveAttributeValues(String var1, List<Object> var2, RegisteredService var3);

    default public Map<String, List<Object>> resolveAttributeValues(Map<String, List<Object>> attributes, RegisteredService registeredService) {
        return attributes.entrySet().stream().map(entry -> {
            Optional<AttributeDefinition> defnResult = this.locateAttributeDefinition((String)entry.getKey());
            if (defnResult.isPresent()) {
                AttributeDefinition definition = defnResult.get();
                List<Object> attributeValues = AttributeDefinitionStore.determineValuesForAttributeDefinition(attributes, entry, definition);
                LOGGER.trace("Resolving attribute [{}] from attribute definition store with values [{}]", entry.getKey(), attributeValues);
                Optional<Pair<AttributeDefinition, List<Object>>> result = this.resolveAttributeValues((String)entry.getKey(), attributeValues, registeredService);
                if (result.isPresent()) {
                    List resolvedValues = (List)result.get().getValue();
                    LOGGER.trace("Resolving attribute [{}] based on attribute definition [{}]", entry.getKey(), (Object)definition);
                    String attributeKey = (String)StringUtils.defaultIfBlank((CharSequence)definition.getName(), (CharSequence)((String)entry.getKey()));
                    LOGGER.trace("Determined attribute name to be [{}] with values [{}]", (Object)attributeKey, (Object)resolvedValues);
                    return Pair.of((Object)attributeKey, (Object)resolvedValues);
                }
            }
            LOGGER.trace("Using already-resolved attribute name/value, as no attribute definition was found for [{}]", entry.getKey());
            return Pair.of((Object)((String)entry.getKey()), (Object)((List)entry.getValue()));
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public boolean isEmpty();
}

