/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public interface RegisteredServiceProperty
extends Serializable {
    public Set<String> getValues();

    @JsonIgnore
    public String getValue();

    @JsonIgnore
    default public <T> T getValue(Class<T> clazz) {
        String value = this.getValue();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return clazz.cast(value);
        }
        return null;
    }

    public boolean contains(String var1);

    @JsonIgnore
    default public boolean getBooleanValue() {
        String value = this.getValue();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return BooleanUtils.toBoolean((String)value);
        }
        return false;
    }

    @JsonFormat(shape=JsonFormat.Shape.OBJECT)
    public static enum RegisteredServiceProperties {
        WSFED_RELYING_PARTY_ID("wsfed.relyingPartyIdentifier", ""),
        TOKEN_AS_SERVICE_TICKET("jwtAsServiceTicket", "false"),
        TOKEN_AS_SERVICE_TICKET_CIPHER_STRATEGY_TYPE("jwtAsServiceTicketCipherStrategyType", "ENCRYPT_AND_SIGN"),
        TOKEN_AS_SERVICE_TICKET_SIGNING_KEY("jwtAsServiceTicketSigningKey", ""),
        TOKEN_AS_SERVICE_TICKET_ENCRYPTION_KEY("jwtAsServiceTicketEncryptionKey", ""),
        ACCESS_TOKEN_AS_JWT_SIGNING_KEY("accessTokenAsJwtSigningKey", ""),
        ACCESS_TOKEN_AS_JWT_CIPHER_STRATEGY_TYPE("accessTokenAsJwtCipherStrategyType", "ENCRYPT_AND_SIGN"),
        ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED("accessTokenAsJwtSigningEnabled", "true"),
        ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED("accessTokenAsJwtEncryptionEnabled", "false"),
        ACCESS_TOKEN_AS_JWT_ENCRYPTION_KEY("accessTokenAsJwtEncryptionKey", ""),
        TOKEN_SECRET_SIGNING("jwtSigningSecret", ""),
        TOKEN_SECRET_SIGNING_ALG("jwtSigningSecretAlg", "HS256"),
        TOKEN_SECRET_ENCRYPTION("jwtEncryptionSecret", ""),
        TOKEN_SECRET_ENCRYPTION_ALG("jwtEncryptionSecretAlg", ""),
        TOKEN_SECRET_ENCRYPTION_METHOD("jwtEncryptionSecretMethod", "A192CBC-HS384"),
        TOKEN_SECRETS_ARE_BASE64_ENCODED("jwtSecretsAreBase64Encoded", "false"),
        SKIP_INTERRUPT_NOTIFICATIONS("skipInterrupt", "false"),
        SKIP_REQUIRED_SERVICE_CHECK("skipRequiredServiceCheck", "false"),
        HTTP_HEADER_ENABLE_CACHE_CONTROL("httpHeaderEnableCacheControl", "true"),
        HTTP_HEADER_ENABLE_XCONTENT_OPTIONS("httpHeaderEnableXContentOptions", "true"),
        HTTP_HEADER_ENABLE_STRICT_TRANSPORT_SECURITY("httpHeaderEnableStrictTransportSecurity", "true"),
        HTTP_HEADER_ENABLE_XFRAME_OPTIONS("httpHeaderEnableXFrameOptions", "true"),
        HTTP_HEADER_XFRAME_OPTIONS("httpHeaderXFrameOptions", "DENY"),
        HTTP_HEADER_ENABLE_CONTENT_SECURITY_POLICY("httpHeaderEnableContentSecurityPolicy", "true"),
        HTTP_HEADER_ENABLE_XSS_PROTECTION("httpHeaderEnableXSSProtection", "true");

        private final String propertyName;
        private final String defaultValue;

        @JsonIgnore
        public RegisteredServiceProperty getPropertyValue(RegisteredService service) {
            Optional<Map.Entry> property;
            if (this.isAssignedTo(service) && (property = service.getProperties().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(this.getPropertyName()) && StringUtils.isNotBlank((CharSequence)((RegisteredServiceProperty)entry.getValue()).getValue())).distinct().findFirst()).isPresent()) {
                return (RegisteredServiceProperty)property.get().getValue();
            }
            return null;
        }

        @JsonIgnore
        public <T> T getPropertyValue(RegisteredService service, Class<T> clazz) {
            RegisteredServiceProperty prop;
            if (this.isAssignedTo(service) && (prop = this.getPropertyValue(service)) != null) {
                return clazz.cast(prop.getValue());
            }
            return null;
        }

        @JsonIgnore
        public int getPropertyIntegerValue(RegisteredService service) {
            RegisteredServiceProperty prop;
            if (this.isAssignedTo(service) && (prop = this.getPropertyValue(service)) != null) {
                return Integer.parseInt(prop.getValue());
            }
            return Integer.MIN_VALUE;
        }

        @JsonIgnore
        public long getPropertyLongValue(RegisteredService service) {
            RegisteredServiceProperty prop;
            if (this.isAssignedTo(service) && (prop = this.getPropertyValue(service)) != null) {
                return Long.parseLong(prop.getValue());
            }
            return Long.MIN_VALUE;
        }

        @JsonIgnore
        public double getPropertyDoubleValue(RegisteredService service) {
            RegisteredServiceProperty prop;
            if (this.isAssignedTo(service) && (prop = this.getPropertyValue(service)) != null) {
                return Double.parseDouble(prop.getValue());
            }
            return Double.NaN;
        }

        @JsonIgnore
        public boolean getPropertyBooleanValue(RegisteredService service) {
            RegisteredServiceProperty prop;
            if (this.isAssignedTo(service) && (prop = this.getPropertyValue(service)) != null) {
                return BooleanUtils.toBoolean((String)prop.getValue());
            }
            return BooleanUtils.toBoolean((String)this.getDefaultValue());
        }

        @JsonIgnore
        public boolean isAssignedTo(RegisteredService service) {
            return this.isAssignedTo(service, s -> true);
        }

        @JsonIgnore
        public boolean isAssignedTo(RegisteredService service, Predicate<String> valueFilter) {
            return service.getProperties().entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equalsIgnoreCase(this.getPropertyName()) && StringUtils.isNotBlank((CharSequence)((RegisteredServiceProperty)entry.getValue()).getValue()) && valueFilter.test(((RegisteredServiceProperty)entry.getValue()).getValue()));
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        private RegisteredServiceProperties(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }
    }
}

