/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;

public interface ServiceRegistry {
    public RegisteredService save(RegisteredService var1);

    public boolean delete(RegisteredService var1);

    public Collection<RegisteredService> load();

    default public Stream<? extends RegisteredService> getServicesStream() {
        return this.load().stream();
    }

    public RegisteredService findServiceById(long var1);

    default public <T extends RegisteredService> T findServiceById(long id, Class<T> clazz) {
        RegisteredService service = this.findServiceById(id);
        if (service == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Object [" + service + " is of type " + service.getClass() + " when we were expecting " + clazz);
        }
        return (T)((RegisteredService)clazz.cast(service));
    }

    default public RegisteredService findServiceByExactServiceId(String id) {
        return this.load().stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getServiceId()) && r.getServiceId().equals(id)).findFirst().orElse(null);
    }

    default public RegisteredService findServiceByExactServiceName(String name) {
        return this.load().stream().filter(r -> r.getName().equals(name)).findFirst().orElse(null);
    }

    default public <T extends RegisteredService> T findServiceByExactServiceName(String name, Class<T> clazz) {
        RegisteredService service = this.findServiceByExactServiceName(name);
        if (service == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Object [" + service + " is of type " + service.getClass() + " when we were expecting " + clazz);
        }
        return (T)((RegisteredService)clazz.cast(service));
    }

    default public RegisteredService findServicePredicate(Predicate<RegisteredService> predicate) {
        return this.load().stream().filter(predicate).findFirst().orElse(null);
    }

    default public long size() {
        return this.load().size();
    }

    default public String getName() {
        return this.getClass().getSimpleName();
    }
}

