/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;

public interface ServicesManager {
    public RegisteredService save(RegisteredService var1);

    public RegisteredService save(RegisteredService var1, boolean var2);

    default public void save(RegisteredService ... services) {
        Arrays.stream(services).forEach(this::save);
    }

    public void deleteAll();

    public RegisteredService delete(long var1);

    public RegisteredService delete(RegisteredService var1);

    public RegisteredService findServiceBy(String var1);

    public RegisteredService findServiceBy(Service var1);

    public Collection<RegisteredService> findServiceBy(Predicate<RegisteredService> var1);

    public <T extends RegisteredService> T findServiceBy(Service var1, Class<T> var2);

    public <T extends RegisteredService> T findServiceBy(String var1, Class<T> var2);

    public RegisteredService findServiceBy(long var1);

    default public <T extends RegisteredService> T findServiceBy(long id, Class<T> clazz) {
        RegisteredService service = this.findServiceBy(id);
        if (service != null && clazz.isAssignableFrom(service.getClass())) {
            return (T)service;
        }
        return null;
    }

    public Collection<RegisteredService> getAllServices();

    default public Stream<? extends RegisteredService> getAllServicesStream() {
        return this.getAllServices().stream();
    }

    public Collection<RegisteredService> load();

    default public int count() {
        return 0;
    }

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public boolean supports(Service service) {
        return true;
    }

    default public boolean supports(RegisteredService service) {
        return true;
    }

    default public boolean supports(Class clazz) {
        return true;
    }
}

