/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="RegisteredService")
public class RegisteredServicePropertyTests {
    @Test
    public void verifyNull() {
        DefaultRegisteredServiceProperty p1 = new DefaultRegisteredServiceProperty(null);
        Assertions.assertNull((Object)p1.getValue(String.class));
        Assertions.assertFalse((boolean)p1.getBooleanValue());
    }

    @Test
    public void verifyValue() {
        DefaultRegisteredServiceProperty p1 = new DefaultRegisteredServiceProperty("true");
        Assertions.assertEquals((Object)"true", (Object)p1.getValue(String.class));
        Assertions.assertTrue((boolean)p1.getBooleanValue());
    }

    @Test
    public void verifyTypedValue() {
        RegisteredService service = (RegisteredService)Mockito.mock(RegisteredService.class);
        Map<String, DefaultRegisteredServiceProperty> properties = Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_CIPHER_STRATEGY_TYPE.getPropertyName(), new DefaultRegisteredServiceProperty("ENCRYPT_AND_SIGN"), RegisteredServiceProperty.RegisteredServiceProperties.CORS_MAX_AGE.getPropertyName(), new DefaultRegisteredServiceProperty("100"), RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_SAML2_ASSERTION_CONSUMER_SERVICE_INDEX.getPropertyName(), new DefaultRegisteredServiceProperty("1"), RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_SAML2_AUTHN_CONTEXT_CLASS_REFS.getPropertyName(), new DefaultRegisteredServiceProperty("class1"), RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_SAML2_MAXIMUM_AUTHN_LIFETIME.getPropertyName(), new DefaultRegisteredServiceProperty("100"), RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty("true"));
        Mockito.when((Object)service.getProperties()).thenReturn(properties);
        Assertions.assertNotNull((Object)RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_CIPHER_STRATEGY_TYPE.getTypedPropertyValue(service));
        Assertions.assertNotNull((Object)RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getTypedPropertyValue(service));
        Assertions.assertNotNull((Object)RegisteredServiceProperty.RegisteredServiceProperties.CORS_MAX_AGE.getTypedPropertyValue(service));
        Assertions.assertNotNull((Object)RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_SAML2_ASSERTION_CONSUMER_SERVICE_INDEX.getTypedPropertyValue(service));
        Assertions.assertNotNull((Object)RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_SAML2_AUTHN_CONTEXT_CLASS_REFS.getTypedPropertyValue(service));
        Assertions.assertNotNull((Object)RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_SAML2_MAXIMUM_AUTHN_LIFETIME.getTypedPropertyValue(service));
    }

    private static class DefaultRegisteredServiceProperty
    implements RegisteredServiceProperty {
        private static final long serialVersionUID = -4878764188998002053L;
        private final String value;

        public Set<String> getValues() {
            return Set.of();
        }

        public boolean contains(String value) {
            return false;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public DefaultRegisteredServiceProperty(String value) {
            this.value = value;
        }
    }
}

