/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="RegisteredService")
public class ServiceRegistryTests {
    @Test
    public void verifyFindById() {
        ServiceRegistry component = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        RegisteredService service = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)component.findServiceById(Mockito.anyLong())).thenReturn((Object)service);
        Mockito.when((Object)component.findServiceById(Mockito.anyLong(), (Class)Mockito.any())).thenCallRealMethod();
        Assertions.assertThrows(ClassCastException.class, () -> component.findServiceById(1L, BaseMockRegisteredService.class));
    }

    @Test
    public void verifyFindByName() {
        ServiceRegistry component = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)component.findServiceByExactServiceName(Mockito.anyString())).thenReturn(null);
        Mockito.when((Object)component.findServiceByExactServiceName(Mockito.anyString(), (Class)Mockito.any())).thenCallRealMethod();
        Assertions.assertNull((Object)component.findServiceByExactServiceName("test", BaseMockRegisteredService.class));
        RegisteredService service = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)component.findServiceByExactServiceName(Mockito.anyString())).thenReturn((Object)service);
        Assertions.assertThrows(ClassCastException.class, () -> component.findServiceByExactServiceName("test", BaseMockRegisteredService.class));
    }

    private static abstract class BaseMockRegisteredService
    implements RegisteredService {
        private static final long serialVersionUID = 5470970585502265482L;

        private BaseMockRegisteredService() {
        }
    }
}

