/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cache;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class DistributedCacheObject<V extends Serializable>
implements Serializable {
    private static final int MAP_SIZE = 8;
    private static final long serialVersionUID = -6776499291439952013L;
    private final long timestamp;
    private final V value;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>(8);

    public DistributedCacheObject(V value) {
        this(new Date().getTime(), value);
    }

    public DistributedCacheObject(long timestamp, V value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public <T> T getProperty(String name, Class<T> clazz) {
        if (this.containsProperty(name)) {
            Object item = this.properties.get(name);
            if (item == null) {
                return null;
            }
            if (!clazz.isAssignableFrom(item.getClass())) {
                throw new ClassCastException("Object [" + item + " is of type " + item.getClass() + " when we were expecting " + clazz);
            }
            return (T)item;
        }
        return null;
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Generated
    public String toString() {
        return "DistributedCacheObject(timestamp=" + this.timestamp + ", value=" + this.value + ", properties=" + this.properties + ")";
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public V getValue() {
        return this.value;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

