/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.model;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class Capacity
implements Serializable {
    private static final long serialVersionUID = -331719796564884951L;
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+(\\.\\d+)*)\\s*(\\S+)");
    private final UnitOfMeasure unitOfMeasure;
    private final Double size;

    public static Capacity parse(String capacity) {
        Matcher matcher = SIZE_PATTERN.matcher(capacity);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid capacity definition: " + capacity);
        }
        double count = Double.parseDouble(matcher.group(1));
        UnitOfMeasure unit = UnitOfMeasure.valueOf(matcher.group(3).toUpperCase());
        return Capacity.builder().unitOfMeasure(unit).size(count).build();
    }

    @Generated
    Capacity(UnitOfMeasure unitOfMeasure, Double size) {
        this.unitOfMeasure = unitOfMeasure;
        this.size = size;
    }

    @Generated
    public static CapacityBuilder builder() {
        return new CapacityBuilder();
    }

    @Generated
    public UnitOfMeasure getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @Generated
    public Double getSize() {
        return this.size;
    }

    @Generated
    public static class CapacityBuilder {
        @Generated
        private UnitOfMeasure unitOfMeasure;
        @Generated
        private Double size;

        @Generated
        CapacityBuilder() {
        }

        @Generated
        public CapacityBuilder unitOfMeasure(UnitOfMeasure unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        @Generated
        public CapacityBuilder size(Double size) {
            this.size = size;
            return this;
        }

        @Generated
        public Capacity build() {
            return new Capacity(this.unitOfMeasure, this.size);
        }

        @Generated
        public String toString() {
            return "Capacity.CapacityBuilder(unitOfMeasure=" + this.unitOfMeasure + ", size=" + this.size + ")";
        }
    }

    public static enum UnitOfMeasure {
        B,
        KB,
        MB,
        GB,
        TB;

    }
}

