/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import org.apereo.cas.audit.spi.FilterAndDelegateAuditTrailManager;
import org.apereo.cas.audit.spi.MockAuditTrailManager;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Audits")
public class FilterAndDelegateAuditTrailManagerTests {
    @Test
    public void verifyExcludeOperationForAllActions() {
        AuditActionContext ctx = new AuditActionContext("casuser", "TEST", "TEST", "CAS", new Date(), "1.2.3.4", "1.2.3.4");
        MockAuditTrailManager mock = new MockAuditTrailManager();
        FilterAndDelegateAuditTrailManager mgr = new FilterAndDelegateAuditTrailManager(List.of(mock), List.of("*"), List.of("TES.+"));
        mgr.record(ctx);
        Assertions.assertTrue((boolean)mock.getAuditRecords().isEmpty());
    }

    @Test
    public void verifyOperationForAllActions() {
        AuditActionContext ctx = new AuditActionContext("casuser", "TEST", "TEST", "CAS", new Date(), "1.2.3.4", "1.2.3.4");
        MockAuditTrailManager mock = new MockAuditTrailManager();
        FilterAndDelegateAuditTrailManager mgr = new FilterAndDelegateAuditTrailManager(List.of(mock), List.of("*"), List.of());
        mgr.record(ctx);
        Assertions.assertFalse((boolean)mock.getAuditRecords().isEmpty());
    }

    @Test
    public void verifyOperationForAllSupportedActions() {
        AuditActionContext ctx = new AuditActionContext("casuser", "TEST", "TEST", "CAS", new Date(), "1.2.3.4", "1.2.3.4");
        MockAuditTrailManager mock = new MockAuditTrailManager();
        FilterAndDelegateAuditTrailManager mgr = new FilterAndDelegateAuditTrailManager(List.of(mock), List.of("TEST.*"), List.of());
        mgr.record(ctx);
        Assertions.assertFalse((boolean)mock.getAuditRecords().isEmpty());
    }

    @Test
    public void verifyOperationForUnmatchedActions() {
        AuditActionContext ctx = new AuditActionContext("casuser", "TEST", "TEST", "CAS", new Date(), "1.2.3.4", "1.2.3.4");
        MockAuditTrailManager mock = new MockAuditTrailManager();
        FilterAndDelegateAuditTrailManager mgr = new FilterAndDelegateAuditTrailManager(List.of(mock), List.of("PASSED.*"), List.of());
        mgr.record(ctx);
        Assertions.assertTrue((boolean)mock.getAuditRecords().isEmpty());
    }

    @Test
    public void verifyAuditRecordsSinceDate() {
        AuditActionContext ctx = new AuditActionContext("casuser", "TEST", "TEST", "CAS", DateTimeUtils.dateOf((LocalDateTime)LocalDateTime.now(ZoneOffset.UTC).plusDays(1L)), "1.2.3.4", "1.2.3.4");
        MockAuditTrailManager mock = new MockAuditTrailManager();
        FilterAndDelegateAuditTrailManager mgr = new FilterAndDelegateAuditTrailManager(List.of(mock), List.of("TEST.*"), List.of());
        mgr.record(ctx);
        Assertions.assertFalse((boolean)mock.getAuditRecords().isEmpty());
        Assertions.assertEquals((int)1, (int)mgr.getAuditRecordsSince(LocalDate.now(ZoneOffset.UTC)).size());
        Assertions.assertDoesNotThrow(() -> ((FilterAndDelegateAuditTrailManager)mgr).removeAll());
    }
}

