/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import java.time.LocalDate;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;

public class MockAuditTrailManager
implements AuditTrailManager {
    private final Set<AuditActionContext> auditRecords = new LinkedHashSet<AuditActionContext>();

    public void record(AuditActionContext auditActionContext) {
        this.auditRecords.add(auditActionContext);
    }

    public Set<? extends AuditActionContext> getAuditRecordsSince(LocalDate localDate) {
        Date dt = DateTimeUtils.dateOf((LocalDate)localDate);
        return this.auditRecords.stream().filter(audit -> audit.getWhenActionWasPerformed().compareTo(dt) >= 0).collect(Collectors.toSet());
    }

    public void removeAll() {
        this.auditRecords.clear();
    }

    @Generated
    public Set<AuditActionContext> getAuditRecords() {
        return this.auditRecords;
    }
}

